/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IHazardParticleContainer;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.common.capability.LocalizedHazardSavedData;
import com.gregtechceu.gtceu.common.data.GTMedicalConditions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public interface ILocalizedHazardEmitter
extends IMachineFeature {
    default public MedicalCondition getConditionToEmit() {
        return GTMedicalConditions.CARCINOGEN;
    }

    public int getHazardSizePerOperation();

    default public void spreadLocalizedHazard() {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        Level level = this.self().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            IHazardParticleContainer container = GTCapabilityHelper.getHazardContainer((Level)serverLevel, this.self().getPos().m_121945_(this.self().getFrontFacing()), this.self().getFrontFacing().m_122424_());
            if (container != null && container.getHazardCanBeInserted(this.getConditionToEmit()) > (float)this.getHazardSizePerOperation()) {
                container.addHazard(this.getConditionToEmit(), this.getHazardSizePerOperation());
                return;
            }
            LocalizedHazardSavedData savedData = LocalizedHazardSavedData.getOrCreate(serverLevel);
            savedData.addSphericalZone(this.self().getPos(), this.getHazardSizePerOperation(), false, HazardProperty.HazardTrigger.INHALATION, this.getConditionToEmit());
        }
    }
}

