/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.fancyconfigurator;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class FancyInvConfigurator
implements IFancyConfigurator {
    private final CustomItemStackHandler inventory;
    private final Component title;
    private List<Component> tooltips = Collections.emptyList();

    public FancyInvConfigurator(CustomItemStackHandler inventory, Component title) {
        this.inventory = inventory;
        this.title = title;
    }

    @Override
    public IGuiTexture getIcon() {
        return GuiTextures.BUTTON_ITEM_OUTPUT;
    }

    @Override
    public Widget createConfigurator() {
        int rowSize;
        int colSize = rowSize = (int)Math.sqrt(this.inventory.getSlots());
        if (this.inventory.getSlots() == 8) {
            rowSize = 4;
            colSize = 2;
        }
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize + 16, 18 * colSize + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * rowSize + 8, 18 * colSize + 8);
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                container.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)this.inventory, index++, 4 + x * 18, 4 + y * 18, true, true).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT).setIngredientIO(IngredientIO.INPUT));
            }
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Override
    @Generated
    public Component getTitle() {
        return this.title;
    }

    @Override
    @Generated
    public List<Component> getTooltips() {
        return this.tooltips;
    }

    @NotNull
    @Generated
    public FancyInvConfigurator setTooltips(List<Component> tooltips) {
        this.tooltips = tooltips;
        return this;
    }
}

