/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.fancy;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.PageSwitcher;
import com.gregtechceu.gtceu.api.gui.fancy.TitleBarWidget;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.gui.fancy.VerticalTabsWidget;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.custom.PlayerInventoryWidget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class FancyMachineUIWidget
extends WidgetGroup {
    protected final TitleBarWidget titleBar;
    protected final VerticalTabsWidget sideTabsWidget;
    protected final WidgetGroup pageContainer;
    protected final PageSwitcher pageSwitcher;
    protected final ConfiguratorPanel configuratorPanel;
    protected final TooltipsPanel tooltipsPanel;
    @Nullable
    protected final PlayerInventoryWidget playerInventory;
    protected int border = 4;
    protected final IFancyUIProvider mainPage;
    protected IFancyUIProvider currentPage;
    protected IFancyUIProvider currentHomePage;
    protected List<IFancyUIProvider> allPages;
    protected Deque<NavigationEntry> previousPages = new ArrayDeque<NavigationEntry>();

    public FancyMachineUIWidget(IFancyUIProvider mainPage, int width, int height) {
        super(0, 0, width, height);
        this.mainPage = mainPage;
        this.pageContainer = new WidgetGroup(0, 0, width, height);
        this.addWidget((Widget)this.pageContainer);
        if (mainPage.hasPlayerInventory()) {
            this.playerInventory = new PlayerInventoryWidget();
            this.addWidget((Widget)this.playerInventory);
            this.playerInventory.setSelfPosition(new Position(2, height - 86));
            this.playerInventory.setBackground(new IGuiTexture[]{null});
        } else {
            this.playerInventory = null;
        }
        this.titleBar = new TitleBarWidget(width, this::navigateBack, this::openPageSwitcher);
        this.addWidget((Widget)this.titleBar);
        this.sideTabsWidget = new VerticalTabsWidget(this::navigate, -20, 0, 24, height);
        this.addWidget(this.sideTabsWidget);
        this.tooltipsPanel = new TooltipsPanel();
        this.addWidget(this.tooltipsPanel);
        this.configuratorPanel = new ConfiguratorPanel(-26, height);
        this.addWidget((Widget)this.configuratorPanel);
        this.pageSwitcher = new PageSwitcher(this::switchPage);
        this.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND.copy().setColor(Long.decode(ConfigHolder.INSTANCE.client.defaultUIColor).intValue() | 0xFF000000)});
    }

    public void initWidget() {
        super.initWidget();
        if (this.playerInventory != null) {
            this.playerInventory.setPlayer(this.gui.entityPlayer);
        }
        this.allPages = Stream.concat(Stream.of(this.mainPage), this.mainPage.getSubTabs().stream()).toList();
        this.performNavigation(this.mainPage, this.mainPage);
    }

    protected void navigate(IFancyUIProvider newPage) {
        this.navigate(newPage, this.currentHomePage);
    }

    protected void navigate(IFancyUIProvider nextPage, IFancyUIProvider nextHomePage) {
        if (nextPage != this.mainPage) {
            if (!this.previousPages.isEmpty() && this.previousPages.peek().page == nextPage) {
                this.previousPages.pop();
            } else if (this.currentPage != null) {
                this.previousPages.push(new NavigationEntry(this.currentPage, this.currentHomePage, () -> {}));
            }
        } else {
            this.previousPages.clear();
        }
        this.performNavigation(nextPage, nextHomePage);
    }

    protected void navigateBack(ClickData clickData) {
        NavigationEntry navigationEntry = this.previousPages.pop();
        this.performNavigation(navigationEntry.page, navigationEntry.homePage);
        navigationEntry.onNavigation.run();
    }

    protected void performNavigation(IFancyUIProvider nextPage, IFancyUIProvider nextHomePage) {
        if (this.currentHomePage != nextHomePage) {
            this.setupSideTabs(nextHomePage);
        }
        this.currentPage = nextPage;
        this.currentHomePage = nextHomePage;
        if (this.currentPage != this.currentHomePage) {
            this.setupFancyUI(this.currentHomePage);
        }
        this.setupFancyUI(nextPage, nextPage.hasPlayerInventory());
    }

    protected void openPageSwitcher(ClickData clickData) {
        this.pageSwitcher.setPageList(this.allPages, this.currentHomePage);
        if (this.currentPage != this.currentHomePage && !this.previousPages.isEmpty()) {
            this.previousPages.pop();
        }
        this.sideTabsWidget.setVisible(false);
        this.sideTabsWidget.setActive(false);
        this.previousPages.push(new NavigationEntry(this.currentHomePage, this.currentHomePage, () -> {
            this.sideTabsWidget.setVisible(true);
            this.sideTabsWidget.setActive(true);
        }));
        this.currentPage = this.pageSwitcher;
        this.currentHomePage = this.pageSwitcher;
        this.setupFancyUI(this.pageSwitcher);
    }

    protected void switchPage(IFancyUIProvider nextHomePage) {
        this.currentHomePage = this.mainPage;
        this.currentPage = this.mainPage;
        this.previousPages.clear();
        this.sideTabsWidget.setVisible(true);
        this.sideTabsWidget.setActive(true);
        this.setupSideTabs(this.currentHomePage);
        this.navigate(nextHomePage, nextHomePage);
    }

    protected void setupFancyUI(IFancyUIProvider fancyUI) {
        this.setupFancyUI(fancyUI, fancyUI.hasPlayerInventory());
    }

    protected void setupFancyUI(IFancyUIProvider fancyUI, boolean showInventory) {
        this.clearUI();
        this.sideTabsWidget.selectTab(fancyUI);
        this.titleBar.updateState(this.currentHomePage, !this.previousPages.isEmpty(), this.allPages.size() > 1 && this.currentPage != this.pageSwitcher);
        Widget page = fancyUI.createMainPage(this);
        Size size = new Size(Math.max(172, page.getSize().width + this.border * 2), Math.max(86, page.getSize().height + this.border * 2));
        this.setSize(new Size(size.width, size.height + (!showInventory || this.playerInventory == null ? 0 : this.playerInventory.getSize().height)));
        if (GTCEu.isClientSide() && this.getGui() != null) {
            this.getGui().setSize(this.getSize().width, this.getSize().height);
        }
        this.sideTabsWidget.setSize(new Size(24, size.height));
        this.pageContainer.setSize(size);
        this.tooltipsPanel.setSelfPosition(new Position(size.width + 2, 2));
        this.setupInventoryPosition(showInventory, size);
        this.pageContainer.addWidget(page);
        page.setSelfPosition(new Position((this.pageContainer.getSize().width - page.getSize().width) / 2, (this.pageContainer.getSize().height - page.getSize().height) / 2));
        fancyUI.attachConfigurators(this.configuratorPanel);
        this.configuratorPanel.setSelfPosition(new Position(-26, this.getGui().getHeight() - this.configuratorPanel.getSize().height - 4));
        fancyUI.attachTooltips(this.tooltipsPanel);
        this.titleBar.setSize(new Size(this.getSize().width, this.titleBar.getSize().height));
    }

    private void setupInventoryPosition(boolean showInventory, Size parentSize) {
        if (this.playerInventory == null) {
            return;
        }
        this.playerInventory.setSelfPosition(new Position((parentSize.width - this.playerInventory.getSize().width) / 2, parentSize.height));
        this.playerInventory.setActive(showInventory);
        this.playerInventory.setVisible(showInventory);
    }

    protected void clearUI() {
        this.pageContainer.clearAllWidgets();
        this.configuratorPanel.clear();
        this.tooltipsPanel.clear();
    }

    protected void setupSideTabs(IFancyUIProvider currentHomePage) {
        this.sideTabsWidget.clearSubTabs();
        currentHomePage.attachSideTabs(this.sideTabsWidget);
    }

    @Generated
    public TitleBarWidget getTitleBar() {
        return this.titleBar;
    }

    @Generated
    public VerticalTabsWidget getSideTabsWidget() {
        return this.sideTabsWidget;
    }

    @Generated
    public WidgetGroup getPageContainer() {
        return this.pageContainer;
    }

    @Generated
    public PageSwitcher getPageSwitcher() {
        return this.pageSwitcher;
    }

    @Generated
    public ConfiguratorPanel getConfiguratorPanel() {
        return this.configuratorPanel;
    }

    @Generated
    public TooltipsPanel getTooltipsPanel() {
        return this.tooltipsPanel;
    }

    @Nullable
    @Generated
    public PlayerInventoryWidget getPlayerInventory() {
        return this.playerInventory;
    }

    @Generated
    public int getBorder() {
        return this.border;
    }

    @Generated
    public IFancyUIProvider getMainPage() {
        return this.mainPage;
    }

    @Generated
    public IFancyUIProvider getCurrentPage() {
        return this.currentPage;
    }

    @Generated
    public IFancyUIProvider getCurrentHomePage() {
        return this.currentHomePage;
    }

    @Generated
    public List<IFancyUIProvider> getAllPages() {
        return this.allPages;
    }

    @Generated
    public Deque<NavigationEntry> getPreviousPages() {
        return this.previousPages;
    }

    @Generated
    public void setBorder(int border) {
        this.border = border;
    }

    protected record NavigationEntry(IFancyUIProvider page, IFancyUIProvider homePage, Runnable onNavigation) {
    }
}

