/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.jetbrains.annotations.Nullable;

public class GTLayerPattern {
    public static final Codec<GTLayerPattern> CODEC = Codec.list(Layer.CODEC).xmap(GTLayerPattern::new, pattern -> pattern.layers);
    public final List<Layer> layers;

    public GTLayerPattern(List<Layer> layers) {
        this.layers = layers;
    }

    public Layer rollNext(@Nullable Layer previous, RandomSource random) {
        int totalWeight = 0;
        for (Layer layer : this.layers) {
            if (layer == previous) continue;
            totalWeight += layer.weight;
        }
        int rolled = random.m_188503_(totalWeight);
        for (Layer layer : this.layers) {
            if (layer == previous || (rolled -= layer.weight) >= 0) continue;
            return layer;
        }
        return null;
    }

    public static Builder builder(RuleTest ... rules) {
        return new Builder(rules);
    }

    public static class Layer {
        public static final Codec<Layer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.either((Codec)OreConfiguration.TargetBlockState.f_161031_.listOf(), GTCEuAPI.materialManager.codec())).fieldOf("targets").forGetter(layer -> layer.targets), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("min_size").forGetter(layer -> layer.minSize), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("max_size").forGetter(layer -> layer.maxSize), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(layer -> layer.weight)).apply((Applicative)instance, Layer::new));
        public final List<Either<List<OreConfiguration.TargetBlockState>, Material>> targets;
        public final int minSize;
        public final int maxSize;
        public final int weight;

        public Layer(List<Either<List<OreConfiguration.TargetBlockState>, Material>> targets, int minSize, int maxSize, int weight) {
            this.targets = targets;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.weight = weight;
        }

        public Stream<VeinGenerator.VeinEntry> asVeinEntries() {
            return this.targets.stream().flatMap(target -> VeinGenerator.mapTarget((Either<List<OreConfiguration.TargetBlockState>, Material>)target, this.weight));
        }

        public Either<List<OreConfiguration.TargetBlockState>, Material> rollBlock(RandomSource random) {
            if (this.targets.size() == 1) {
                return this.targets.get(0);
            }
            return this.targets.get(random.m_188503_(this.targets.size()));
        }

        public static class Builder {
            private final List<Either<List<OreConfiguration.TargetBlockState>, Material>> targets = new ArrayList<Either<List<OreConfiguration.TargetBlockState>, Material>>();
            private int minSize = 1;
            private int maxSize = 1;
            private int weight = 1;
            private final RuleTest[] rules;

            protected Builder(RuleTest ... rules) {
                this.rules = rules;
            }

            public Builder block(Supplier<? extends Block> block) {
                return this.state(block.get().m_49966_());
            }

            public Builder state(Supplier<? extends BlockState> state) {
                return this.state(state.get());
            }

            public Builder state(BlockState state) {
                this.targets.add((Either<List<OreConfiguration.TargetBlockState>, Material>)Either.left(Arrays.stream(this.rules).map(rule -> OreConfiguration.m_161021_((RuleTest)rule, (BlockState)state)).toList()));
                return this;
            }

            public Builder mat(Material material) {
                this.targets.add((Either<List<OreConfiguration.TargetBlockState>, Material>)Either.right((Object)material));
                return this;
            }

            public Builder weight(int weight) {
                this.weight = weight;
                return this;
            }

            public Builder size(int min, int max) {
                this.minSize = min;
                this.maxSize = max;
                return this;
            }

            public Layer build() {
                return new Layer(this.targets, this.minSize, this.maxSize, this.weight);
            }
        }
    }

    public static class Builder {
        private final List<Layer> layers = new ArrayList<Layer>();
        private final RuleTest[] rules;

        protected Builder(RuleTest ... rules) {
            this.rules = rules;
        }

        public Builder layer(Consumer<Layer.Builder> builder) {
            Layer.Builder layerBuilder = new Layer.Builder(this.rules);
            builder.accept(layerBuilder);
            this.layers.add(layerBuilder.build());
            return this;
        }

        public GTLayerPattern build() {
            return new GTLayerPattern(this.layers);
        }
    }
}

