/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class IngotProperty
implements IMaterialProperty {
    @NotNull
    private Material smeltingInto = GTMaterials.NULL;
    @NotNull
    private Material arcSmeltingInto = GTMaterials.NULL;
    @NotNull
    private Material macerateInto = GTMaterials.NULL;
    @NotNull
    private Material magneticMaterial = GTMaterials.NULL;

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.DUST, true);
        if (properties.hasProperty(PropertyKey.GEM)) {
            throw new IllegalStateException("Material " + String.valueOf(properties.getMaterial()) + " has both Ingot and Gem Property, which is not allowed!");
        }
        if (this.smeltingInto.isNull()) {
            this.smeltingInto = properties.getMaterial();
        } else {
            this.smeltingInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (this.arcSmeltingInto.isNull()) {
            this.arcSmeltingInto = properties.getMaterial();
        } else {
            this.arcSmeltingInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (this.macerateInto.isNull()) {
            this.macerateInto = properties.getMaterial();
        } else {
            this.macerateInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (!this.magneticMaterial.isNull()) {
            this.magneticMaterial.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
    }

    @NotNull
    @Generated
    public Material getSmeltingInto() {
        return this.smeltingInto;
    }

    @Generated
    public void setSmeltingInto(@NotNull Material smeltingInto) {
        if (smeltingInto == null) {
            throw new NullPointerException("smeltingInto is marked non-null but is null");
        }
        this.smeltingInto = smeltingInto;
    }

    @NotNull
    @Generated
    public Material getArcSmeltingInto() {
        return this.arcSmeltingInto;
    }

    @Generated
    public void setArcSmeltingInto(@NotNull Material arcSmeltingInto) {
        if (arcSmeltingInto == null) {
            throw new NullPointerException("arcSmeltingInto is marked non-null but is null");
        }
        this.arcSmeltingInto = arcSmeltingInto;
    }

    @NotNull
    @Generated
    public Material getMacerateInto() {
        return this.macerateInto;
    }

    @Generated
    public void setMacerateInto(@NotNull Material macerateInto) {
        if (macerateInto == null) {
            throw new NullPointerException("macerateInto is marked non-null but is null");
        }
        this.macerateInto = macerateInto;
    }

    @NotNull
    @Generated
    public Material getMagneticMaterial() {
        return this.magneticMaterial;
    }

    @Generated
    public void setMagneticMaterial(@NotNull Material magneticMaterial) {
        if (magneticMaterial == null) {
            throw new NullPointerException("magneticMaterial is marked non-null but is null");
        }
        this.magneticMaterial = magneticMaterial;
    }
}

