/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.data.recipe.misc.RecyclingRecipes;
import com.gregtechceu.gtceu.data.recipe.misc.StoneMachineRecipes;
import com.gregtechceu.gtceu.data.recipe.misc.WoodMachineRecipes;
import com.gregtechceu.gtceu.data.tags.TagsHandler;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.gregtechceu.gtceu.utils.memoization.MemoizedBlockSupplier;
import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.util.entry.RegistryEntry;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMaterialData {
    public static final Map<Item, ItemMaterialInfo> ITEM_MATERIAL_INFO = new Object2ObjectOpenHashMap();
    public static final List<Pair<Supplier<? extends Item>, MaterialEntry>> ITEM_MATERIAL_ENTRY = new ArrayList<Pair<Supplier<? extends Item>, MaterialEntry>>();
    public static final Map<Item, MaterialEntry> ITEM_MATERIAL_ENTRY_COLLECTED = new Object2ObjectOpenHashMap();
    public static final Map<TagKey<Item>, MaterialEntry> TAG_MATERIAL_ENTRY = new Object2ObjectLinkedOpenHashMap();
    public static final Map<Fluid, Material> FLUID_MATERIAL = new Object2ObjectOpenHashMap();
    public static final Map<MaterialEntry, List<Supplier<? extends Item>>> MATERIAL_ENTRY_ITEM_MAP = new Object2ObjectOpenHashMap();
    public static final Map<MaterialEntry, List<Supplier<? extends Block>>> MATERIAL_ENTRY_BLOCK_MAP = new Object2ObjectOpenHashMap();
    public static final Map<Supplier<BlockState>, TagPrefix> ORES_INVERSE = new Object2ReferenceOpenHashMap();
    public static final Map<ItemStack, List<ItemStack>> UNRESOLVED_ITEM_MATERIAL_INFO = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());

    public static void registerMaterialInfo(ItemLike item, ItemMaterialInfo materialInfo) {
        ITEM_MATERIAL_INFO.put(item.m_5456_(), materialInfo);
    }

    public static ItemMaterialInfo getMaterialInfo(ItemLike item) {
        return ITEM_MATERIAL_INFO.get(item.m_5456_());
    }

    public static void clearMaterialInfo(ItemLike item) {
        ITEM_MATERIAL_INFO.remove(item.m_5456_());
    }

    public static void registerMaterialEntry(@NotNull Supplier<? extends ItemLike> supplier, @NotNull MaterialEntry materialEntry) {
        ItemMaterialData.registerItemEntry(supplier, materialEntry);
        ITEM_MATERIAL_ENTRY.add((Pair<Supplier<? extends Item>, MaterialEntry>)Pair.of(() -> ((ItemLike)supplier.get()).m_5456_(), (Object)materialEntry));
        Supplier<? extends Block> blockSupplier = ItemMaterialData.convertToBlock(supplier);
        if (blockSupplier != null) {
            ItemMaterialData.registerBlockEntry(blockSupplier, materialEntry);
        }
    }

    public static void registerMaterialEntries(@NotNull Collection<Supplier<? extends ItemLike>> items, @NotNull TagPrefix tagPrefix, @NotNull Material material) {
        if (!items.isEmpty()) {
            MaterialEntry entry = new MaterialEntry(tagPrefix, material);
            for (Supplier<? extends ItemLike> supplier : items) {
                ItemMaterialData.registerMaterialEntry(supplier, entry);
            }
        }
    }

    public static void registerMaterialEntry(@NotNull Supplier<? extends ItemLike> item, @NotNull TagPrefix tagPrefix, @NotNull Material material) {
        ItemMaterialData.registerMaterialEntry(item, new MaterialEntry(tagPrefix, material));
    }

    public static void registerMaterialEntry(@NotNull ItemLike item, @NotNull TagPrefix tagPrefix, @NotNull Material material) {
        ItemMaterialData.registerMaterialEntry(() -> item, new MaterialEntry(tagPrefix, material));
    }

    private static void registerItemEntry(@NotNull Supplier<? extends ItemLike> supplier, @NotNull MaterialEntry materialEntry) {
        MATERIAL_ENTRY_ITEM_MAP.computeIfAbsent(materialEntry, k -> new ArrayList()).add(() -> ((ItemLike)supplier.get()).m_5456_());
        if (TagPrefix.ORES.containsKey(materialEntry.tagPrefix()) && !ORES_INVERSE.containsValue(materialEntry.tagPrefix())) {
            ORES_INVERSE.put(TagPrefix.ORES.get(materialEntry.tagPrefix()).stoneType(), materialEntry.tagPrefix());
        }
        if (!materialEntry.isEmpty()) {
            for (TagKey<Item> tag : materialEntry.tagPrefix().getAllItemTags(materialEntry.material())) {
                TAG_MATERIAL_ENTRY.putIfAbsent(tag, materialEntry);
            }
        }
    }

    private static void registerBlockEntry(@NotNull Supplier<? extends Block> supplier, @NotNull MaterialEntry materialEntry) {
        MATERIAL_ENTRY_BLOCK_MAP.computeIfAbsent(materialEntry, k -> new ArrayList()).add(supplier);
    }

    @Nullable
    public static Supplier<? extends Block> convertToBlock(@NotNull Supplier<? extends ItemLike> supplier) {
        if (supplier instanceof RegistryObject) {
            RegistryObject registryObject = (RegistryObject)supplier;
            ResourceKey key = registryObject.getKey();
            if (key != null && key.m_135783_(Registries.f_256747_)) {
                return registryObject;
            }
        } else if (supplier instanceof RegistryEntry) {
            RegistryEntry entry = (RegistryEntry)supplier;
            ResourceKey key = entry.getKey();
            if (key.m_135783_(Registries.f_256747_)) {
                return entry;
            }
        } else if (supplier instanceof MemoizedBlockSupplier) {
            MemoizedBlockSupplier blockSupplier = (MemoizedBlockSupplier)supplier;
            return blockSupplier;
        }
        return null;
    }

    public static void reinitializeMaterialData() {
        MATERIAL_ENTRY_ITEM_MAP.clear();
        MATERIAL_ENTRY_BLOCK_MAP.clear();
        ITEM_MATERIAL_ENTRY.clear();
        FLUID_MATERIAL.clear();
        TagsHandler.initExtraUnificationEntries();
        for (TagPrefix prefix : TagPrefix.values()) {
            prefix.getIgnored().forEach((mat, items) -> ItemMaterialData.registerMaterialEntries(Arrays.asList(items), prefix, mat));
        }
        GTMaterialItems.toUnify.forEach((materialEntry, supplier) -> ItemMaterialData.registerMaterialEntry(supplier, materialEntry));
        WoodMachineRecipes.registerMaterialInfo();
        StoneMachineRecipes.registerMaterialInfo();
    }

    @ApiStatus.Internal
    public static void resolveItemMaterialInfos(Consumer<FinishedRecipe> provider) {
        Iterator<Map.Entry<ItemStack, List<ItemStack>>> iter = UNRESOLVED_ITEM_MATERIAL_INFO.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ItemStack, List<ItemStack>> entry = iter.next();
            ItemStack stack = entry.getKey();
            ItemMaterialInfo existingMaterialInfo = ItemMaterialData.recurseFindMaterialInfo(ITEM_MATERIAL_INFO.get(stack.m_41720_()), stack);
            if (existingMaterialInfo != null) {
                RecyclingRecipes.registerRecyclingRecipes(provider, stack.m_255036_(1), existingMaterialInfo.getMaterials(), false, null);
            }
            iter.remove();
        }
    }

    private static ItemMaterialInfo recurseFindMaterialInfo(ItemMaterialInfo info, ItemStack stack) {
        for (ItemStack input : UNRESOLVED_ITEM_MATERIAL_INFO.get(stack)) {
            if (UNRESOLVED_ITEM_MATERIAL_INFO.containsKey(input)) {
                info = ItemMaterialData.recurseFindMaterialInfo(info, input);
                continue;
            }
            ItemMaterialInfo singularMatInfo = ItemMaterialData.getMaterialInfo((ItemLike)input.m_41720_());
            int inputCount = input.m_41613_();
            int outputCount = stack.m_41613_();
            if (singularMatInfo == null) continue;
            ArrayList<MaterialStack> stackList = new ArrayList<MaterialStack>();
            for (MaterialStack matStack : singularMatInfo.getMaterials()) {
                stackList.add(matStack.multiply(inputCount).divide(outputCount));
            }
            if (info == null) {
                info = new ItemMaterialInfo(stackList);
                ITEM_MATERIAL_INFO.put(stack.m_41720_(), info);
                continue;
            }
            info.addMaterialStacks(stackList);
        }
        return info;
    }
}

