/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChemicalHelper {
    @Nullable
    public static ItemMaterialInfo getMaterialInfo(@Nullable Object object) {
        if (object instanceof ItemMaterialInfo) {
            ItemMaterialInfo materialInfo = (ItemMaterialInfo)object;
            return materialInfo;
        }
        if (object instanceof MaterialStack) {
            MaterialStack materialStack = (MaterialStack)object;
            return new ItemMaterialInfo(materialStack);
        }
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            return ItemMaterialData.getMaterialInfo((ItemLike)itemStack.m_41720_());
        }
        if (object instanceof ItemLike) {
            ItemLike item = (ItemLike)object;
            return ItemMaterialData.getMaterialInfo(item);
        }
        if (object instanceof MaterialEntry) {
            MaterialEntry entry = (MaterialEntry)object;
            List<ItemLike> items = ChemicalHelper.getItems(entry);
            if (!items.isEmpty()) {
                return ItemMaterialData.getMaterialInfo(items.get(0));
            }
        } else if (object instanceof Ingredient) {
            Ingredient ing = (Ingredient)object;
            for (ItemStack stack : ing.m_43908_()) {
                ItemMaterialInfo ms = ItemMaterialData.getMaterialInfo((ItemLike)stack.m_41720_());
                if (ms == null) continue;
                return ms;
            }
        }
        return null;
    }

    public static MaterialStack getMaterialStack(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return MaterialStack.EMPTY;
        }
        return ChemicalHelper.getMaterialStack((ItemLike)itemStack.m_41720_());
    }

    public static MaterialStack getMaterialStack(@NotNull MaterialEntry entry) {
        Material entryMaterial = entry.material();
        if (!entryMaterial.isNull()) {
            return new MaterialStack(entryMaterial, entry.tagPrefix().getMaterialAmount(entryMaterial));
        }
        return MaterialStack.EMPTY;
    }

    public static MaterialStack getMaterialStack(ItemLike itemLike) {
        MaterialEntry entry = ChemicalHelper.getMaterialEntry(itemLike);
        if (!entry.isEmpty()) {
            Material entryMaterial = entry.material();
            return new MaterialStack(entryMaterial, entry.tagPrefix().getMaterialAmount(entryMaterial));
        }
        ItemMaterialInfo info = ItemMaterialData.ITEM_MATERIAL_INFO.get(itemLike.m_5456_());
        if (info == null) {
            return MaterialStack.EMPTY;
        }
        if (info.getMaterial().isEmpty()) {
            GTCEu.LOGGER.error("ItemMaterialInfo for {} is empty!", (Object)itemLike);
            return MaterialStack.EMPTY;
        }
        return info.getMaterial();
    }

    public static Material getMaterial(Fluid fluid) {
        if (ItemMaterialData.FLUID_MATERIAL.isEmpty()) {
            Set allFluidTags = BuiltInRegistries.f_257020_.m_203613_().collect(Collectors.toSet());
            for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
                if (!material.hasProperty(PropertyKey.FLUID)) continue;
                FluidProperty property = material.getProperty(PropertyKey.FLUID);
                FluidStorageKey.allKeys().stream().map(property::get).filter(Objects::nonNull).map(f -> Pair.of((Object)f, TagUtil.createFluidTag(BuiltInRegistries.f_257020_.m_7981_(f).m_135815_()))).filter(pair -> allFluidTags.contains(pair.getSecond())).forEach(pair -> {
                    allFluidTags.remove(pair.getSecond());
                    ItemMaterialData.FLUID_MATERIAL.put((Fluid)pair.getFirst(), material);
                });
            }
        }
        return ItemMaterialData.FLUID_MATERIAL.getOrDefault(fluid, GTMaterials.NULL);
    }

    public static TagPrefix getPrefix(ItemLike itemLike) {
        MaterialEntry entry = ChemicalHelper.getMaterialEntry(itemLike);
        if (!entry.isEmpty()) {
            return entry.tagPrefix();
        }
        return TagPrefix.NULL_PREFIX;
    }

    public static ItemStack getDust(Material material, long materialAmount) {
        if (!material.hasProperty(PropertyKey.DUST) || materialAmount <= 0L) {
            return ItemStack.f_41583_;
        }
        if (materialAmount % 3628800L == 0L || materialAmount >= 58060800L) {
            return ChemicalHelper.get(TagPrefix.dust, material, (int)(materialAmount / 3628800L));
        }
        if (materialAmount * 4L % 3628800L == 0L || materialAmount >= 29030400L) {
            return ChemicalHelper.get(TagPrefix.dustSmall, material, (int)(materialAmount * 4L / 3628800L));
        }
        if (materialAmount * 9L >= 3628800L) {
            return ChemicalHelper.get(TagPrefix.dustTiny, material, (int)(materialAmount * 9L / 3628800L));
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getDust(MaterialStack materialStack) {
        return ChemicalHelper.getDust(materialStack.material(), materialStack.amount());
    }

    public static ItemStack getIngot(Material material, long materialAmount) {
        if (!material.hasProperty(PropertyKey.INGOT) || materialAmount <= 0L) {
            return ItemStack.f_41583_;
        }
        if (materialAmount % 32659200L == 0L) {
            return ChemicalHelper.get(TagPrefix.block, material, (int)(materialAmount / 32659200L));
        }
        if (materialAmount % 3628800L == 0L || materialAmount >= 58060800L) {
            return ChemicalHelper.get(TagPrefix.ingot, material, (int)(materialAmount / 3628800L));
        }
        if (materialAmount * 9L >= 3628800L) {
            return ChemicalHelper.get(TagPrefix.nugget, material, (int)(materialAmount * 9L / 3628800L));
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getIngotOrDust(Material material, long materialAmount) {
        ItemStack ingotStack = ChemicalHelper.getIngot(material, materialAmount);
        if (ingotStack != ItemStack.f_41583_) {
            return ingotStack;
        }
        return ChemicalHelper.getDust(material, materialAmount);
    }

    public static ItemStack getIngotOrDust(MaterialStack materialStack) {
        return ChemicalHelper.getIngotOrDust(materialStack.material(), materialStack.amount());
    }

    public static ItemStack getGem(MaterialStack materialStack) {
        if (materialStack.material().hasProperty(PropertyKey.GEM) && !TagPrefix.gem.isIgnored(materialStack.material()) && materialStack.amount() == TagPrefix.gem.getMaterialAmount(materialStack.material())) {
            return ChemicalHelper.get(TagPrefix.gem, materialStack.material(), (int)(materialStack.amount() / 3628800L));
        }
        return ChemicalHelper.getDust(materialStack);
    }

    public static MaterialEntry getMaterialEntry(ItemLike itemLike) {
        Item itemKey = itemLike.m_5456_();
        MaterialEntry materialEntry = ItemMaterialData.ITEM_MATERIAL_ENTRY_COLLECTED.get(itemKey);
        if (materialEntry == null) {
            for (Pair<Supplier<? extends Item>, MaterialEntry> entry : ItemMaterialData.ITEM_MATERIAL_ENTRY) {
                ItemMaterialData.ITEM_MATERIAL_ENTRY_COLLECTED.put(((Item)((Supplier)entry.getFirst()).get()).m_5456_(), (MaterialEntry)entry.getSecond());
            }
            ItemMaterialData.ITEM_MATERIAL_ENTRY.clear();
            materialEntry = ItemMaterialData.ITEM_MATERIAL_ENTRY_COLLECTED.computeIfAbsent(itemKey, item -> {
                for (TagKey itemTag : item.m_5456_().m_204114_().m_203616_().toList()) {
                    MaterialEntry materialEntry1 = ChemicalHelper.getMaterialEntry((TagKey<Item>)itemTag);
                    if (materialEntry1.isEmpty()) continue;
                    if (!Arrays.stream(materialEntry1.tagPrefix().getItemParentTags()).noneMatch(arg_0 -> ((TagKey)itemTag).equals(arg_0))) continue;
                    return materialEntry1;
                }
                return MaterialEntry.NULL_ENTRY;
            });
        }
        return materialEntry;
    }

    public static MaterialEntry getMaterialEntry(TagKey<Item> tag) {
        if (ItemMaterialData.TAG_MATERIAL_ENTRY.isEmpty()) {
            Set allItemTags = BuiltInRegistries.f_257033_.m_203613_().collect(Collectors.toSet());
            for (TagPrefix prefix : TagPrefix.values()) {
                for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
                    Arrays.stream(prefix.getItemTags(material)).filter(allItemTags::contains).forEach(tagKey -> {
                        allItemTags.remove(tagKey);
                        ItemMaterialData.TAG_MATERIAL_ENTRY.put((TagKey<Item>)tagKey, new MaterialEntry(prefix, material));
                    });
                }
            }
        }
        return ItemMaterialData.TAG_MATERIAL_ENTRY.getOrDefault(tag, MaterialEntry.NULL_ENTRY);
    }

    public static List<ItemLike> getItems(MaterialEntry materialEntry) {
        if (materialEntry.material().isNull()) {
            return new ArrayList<ItemLike>();
        }
        return ItemMaterialData.MATERIAL_ENTRY_ITEM_MAP.computeIfAbsent(materialEntry, entry -> {
            TagPrefix prefix = entry.tagPrefix();
            ArrayList<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
            for (TagKey<Item> tag : prefix.getItemTags(entry.material())) {
                for (Holder itemHolder : BuiltInRegistries.f_257033_.m_206058_(tag)) {
                    items.add(() -> ((Holder)itemHolder).m_203334_());
                }
            }
            if (items.isEmpty() && prefix.hasItemTable() && prefix.doGenerateItem(entry.material())) {
                return List.of(() -> prefix.getItemFromTable(entry.material()).get().m_5456_());
            }
            return items;
        }).stream().map(Supplier::get).collect(Collectors.toList());
    }

    public static ItemStack get(MaterialEntry materialEntry, int size) {
        List<ItemLike> list = ChemicalHelper.getItems(materialEntry);
        if (list.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = list.get(0).m_5456_().m_7968_();
        stack.m_41764_(size);
        return stack;
    }

    public static ItemStack get(TagPrefix orePrefix, Material material, int stackSize) {
        return ChemicalHelper.get(new MaterialEntry(orePrefix, material), stackSize);
    }

    public static ItemStack get(TagPrefix orePrefix, Material material) {
        return ChemicalHelper.get(orePrefix, material, 1);
    }

    public static List<Block> getBlocks(MaterialEntry materialEntry) {
        if (materialEntry.isEmpty()) {
            return Collections.emptyList();
        }
        return ItemMaterialData.MATERIAL_ENTRY_BLOCK_MAP.computeIfAbsent(materialEntry, entry -> {
            Supplier<? extends Block> blockSupplier;
            TagPrefix prefix = entry.tagPrefix();
            ArrayList<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
            for (TagKey<Block> tag : prefix.getBlockTags(entry.material())) {
                for (Holder itemHolder : BuiltInRegistries.f_256975_.m_206058_(tag)) {
                    blocks.add(() -> ((Holder)itemHolder).m_203334_());
                }
            }
            if (blocks.isEmpty() && prefix.hasItemTable() && prefix.doGenerateBlock(entry.material()) && (blockSupplier = ItemMaterialData.convertToBlock(prefix.getItemFromTable(entry.material()))) != null) {
                return Collections.singletonList(blockSupplier);
            }
            return blocks;
        }).stream().map(Supplier::get).collect(Collectors.toList());
    }

    @Nullable
    public static Block getBlock(MaterialEntry materialEntry) {
        List<Block> list = ChemicalHelper.getBlocks(materialEntry);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Nullable
    public static Block getBlock(TagPrefix orePrefix, Material material) {
        return ChemicalHelper.getBlock(new MaterialEntry(orePrefix, material));
    }

    @Nullable
    public static TagKey<Block> getBlockTag(TagPrefix orePrefix, @NotNull Material material) {
        TagKey<Block>[] tags = orePrefix.getBlockTags(material);
        if (tags.length > 0) {
            return tags[0];
        }
        return null;
    }

    @Nullable
    public static TagKey<Item> getTag(TagPrefix orePrefix, @NotNull Material material) {
        TagKey<Item>[] tags = orePrefix.getItemTags(material);
        if (tags.length > 0) {
            return tags[0];
        }
        return null;
    }

    public static List<Pair<ItemStack, ItemMaterialInfo>> getAllItemInfos() {
        ArrayList<Pair<ItemStack, ItemMaterialInfo>> f = new ArrayList<Pair<ItemStack, ItemMaterialInfo>>();
        for (Map.Entry<Item, ItemMaterialInfo> entry : ItemMaterialData.ITEM_MATERIAL_INFO.entrySet()) {
            f.add((Pair<ItemStack, ItemMaterialInfo>)Pair.of((Object)new ItemStack((ItemLike)entry.getKey()), (Object)entry.getValue()));
        }
        return f;
    }

    public static Optional<TagPrefix> getOrePrefix(BlockState state) {
        return ItemMaterialData.ORES_INVERSE.entrySet().stream().filter(entry -> ((BlockState)((Supplier)entry.getKey()).get()).equals(state)).map(Map.Entry::getValue).findFirst();
    }
}

