/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroup;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroupDistinctness;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.SerializerFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.fluid.FluidStackMapIngredient;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.client.TooltipsHandler;
import com.gregtechceu.gtceu.common.valueprovider.ModifiedIntProvider;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidStackList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidTagList;
import com.gregtechceu.gtceu.integration.xei.handlers.fluid.CycleFluidEntryHandler;
import com.gregtechceu.gtceu.integration.xei.widgets.GTRecipeWidget;
import com.gregtechceu.gtceu.utils.GTMath;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class FluidRecipeCapability
extends RecipeCapability<FluidIngredient> {
    public static final FluidRecipeCapability CAP = new FluidRecipeCapability();

    protected FluidRecipeCapability() {
        super("fluid", -12816146, true, 1, SerializerFluidIngredient.INSTANCE);
    }

    @Override
    public FluidIngredient copyInner(FluidIngredient content) {
        return content.copy();
    }

    @Override
    public FluidIngredient copyWithModifier(FluidIngredient content, ContentModifier modifier) {
        if (content.isEmpty()) {
            return content.copy();
        }
        if (content instanceof IntProviderFluidIngredient) {
            IntProviderFluidIngredient provider = (IntProviderFluidIngredient)content;
            return IntProviderFluidIngredient.of(provider.getInner(), ModifiedIntProvider.of(provider.getCountProvider(), modifier));
        }
        FluidIngredient copy = content.copy();
        copy.setAmount(modifier.apply(copy.getAmount()));
        return copy;
    }

    @Override
    public List<Object> compressIngredients(Collection<Object> ingredients) {
        ObjectArrayList list = new ObjectArrayList(ingredients.size());
        for (Object item : ingredients) {
            FluidIngredient fluidIngredient;
            boolean isEqual;
            if (item instanceof FluidIngredient) {
                FluidIngredient fluid = (FluidIngredient)item;
                isEqual = false;
                for (Object obj : list) {
                    FluidStack fluidStack;
                    if (obj instanceof FluidIngredient) {
                        fluidIngredient = (FluidIngredient)obj;
                        if (!fluid.equals(fluidIngredient)) continue;
                        isEqual = true;
                        break;
                    }
                    if (!(obj instanceof FluidStack) || !fluid.test(fluidStack = (FluidStack)obj)) continue;
                    isEqual = true;
                    break;
                }
                if (isEqual) continue;
                list.add(fluid);
                continue;
            }
            if (!(item instanceof FluidStack)) continue;
            FluidStack fluidStack = (FluidStack)item;
            isEqual = false;
            for (Object obj : list) {
                FluidStack stack;
                if (obj instanceof FluidIngredient) {
                    fluidIngredient = (FluidIngredient)obj;
                    if (!fluidIngredient.test(fluidStack)) continue;
                    isEqual = true;
                    break;
                }
                if (!(obj instanceof FluidStack) || !fluidStack.isFluidEqual(stack = (FluidStack)obj)) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            list.add(fluidStack);
        }
        return list;
    }

    @Override
    @Nullable
    public List<AbstractMapIngredient> getDefaultMapIngredient(Object object) {
        if (object instanceof FluidIngredient) {
            FluidIngredient ingredient = (FluidIngredient)object;
            return FluidStackMapIngredient.from(ingredient);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isRecipeSearchFilter() {
        return true;
    }

    @Override
    public int limitMaxParallelByOutput(IRecipeCapabilityHolder holder, GTRecipe recipe, int multiplier, boolean tick) {
        if (holder instanceof ICustomParallel) {
            ICustomParallel p = (ICustomParallel)((Object)holder);
            return p.limitFluidParallel(recipe, multiplier, tick);
        }
        List<Content> outputContents = (tick ? recipe.tickOutputs : recipe.outputs).get(this);
        if (outputContents == null || outputContents.isEmpty()) {
            return multiplier;
        }
        if (!holder.hasCapabilityProxies()) {
            return 0;
        }
        List<IRecipeHandler<?>> handlers = holder.getCapabilitiesFlat(IO.OUT, this);
        if (handlers.isEmpty()) {
            return 0;
        }
        int minMultiplier = 0;
        int maxMultiplier = multiplier;
        int maxAmount = 0;
        ArrayList<FluidIngredient> ingredients = new ArrayList<FluidIngredient>(outputContents.size());
        for (Content content : outputContents) {
            FluidIngredient ing = (FluidIngredient)this.of(content.content);
            maxAmount = Math.max(maxAmount, ing.getAmount());
            ingredients.add(ing);
        }
        if (maxAmount == 0) {
            return multiplier;
        }
        if (multiplier > Integer.MAX_VALUE / maxAmount) {
            maxMultiplier = multiplier = Integer.MAX_VALUE / maxAmount;
        }
        while (minMultiplier != maxMultiplier) {
            IRecipeHandler handler;
            List<FluidIngredient> copied = new ArrayList<FluidIngredient>();
            for (FluidIngredient ing : ingredients) {
                copied.add(this.copyWithModifier(ing, ContentModifier.multiplier(multiplier)));
            }
            Iterator<IRecipeHandler<?>> iterator = handlers.iterator();
            while (iterator.hasNext() && (copied = (handler = iterator.next()).handleRecipe(IO.OUT, recipe, copied, true)) != null) {
            }
            int[] nArray = ParallelLogic.adjustMultiplier(copied == null, minMultiplier, multiplier, maxMultiplier);
            minMultiplier = nArray[0];
            multiplier = nArray[1];
            maxMultiplier = nArray[2];
        }
        return multiplier;
    }

    @Override
    public int getMaxParallelByInput(IRecipeCapabilityHolder holder, GTRecipe recipe, int limit, boolean tick) {
        if (!holder.hasCapabilityProxies()) {
            return 0;
        }
        List<Content> inputs = (tick ? recipe.tickInputs : recipe.inputs).get(this);
        if (inputs == null || inputs.isEmpty()) {
            return limit;
        }
        List<Object2LongMap<FluidStack>> inventoryGroups = FluidRecipeCapability.getInputContents(holder);
        if (inventoryGroups.isEmpty()) {
            return 0;
        }
        Object2LongOpenHashMap nonConsumables = new Object2LongOpenHashMap();
        Object2LongOpenHashMap consumables = new Object2LongOpenHashMap();
        for (Content content : inputs) {
            int amount;
            FluidIngredient ing = (FluidIngredient)this.of(content.content);
            if (ing instanceof IntProviderFluidIngredient) {
                IntProviderFluidIngredient provider = (IntProviderFluidIngredient)ing;
                amount = provider.getCountProvider().m_142737_();
            } else {
                amount = ing.getAmount();
            }
            if (content.chance == 0) {
                nonConsumables.addTo((Object)ing, (long)amount);
                continue;
            }
            boolean has = false;
            for (Object2LongMap.Entry recipeIng : consumables.object2LongEntrySet()) {
                FluidStack stack = ing.getStacks()[0];
                if (!((FluidIngredient)recipeIng.getKey()).test(stack)) continue;
                recipeIng.setValue(recipeIng.getLongValue() + (long)stack.getAmount());
                has = true;
                break;
            }
            if (has) continue;
            consumables.addTo((Object)ing, (long)amount);
        }
        if (consumables.isEmpty() && nonConsumables.isEmpty()) {
            return limit;
        }
        int maxMultiplier = 0;
        for (Object2LongMap<FluidStack> group : inventoryGroups) {
            boolean satisfied = true;
            for (Object2LongMap.Entry ncEntry : Object2LongMaps.fastIterable((Object2LongMap)nonConsumables)) {
                FluidIngredient ingredient = (FluidIngredient)ncEntry.getKey();
                long needed = ncEntry.getLongValue();
                for (Object2LongMap.Entry stackEntry : Object2LongMaps.fastIterable(group)) {
                    if (!ingredient.test((FluidStack)stackEntry.getKey())) continue;
                    long count = stackEntry.getLongValue();
                    long lesser = Math.min(needed, count);
                    stackEntry.setValue(count -= lesser);
                    if ((needed -= lesser) != 0L) continue;
                    break;
                }
                if (needed <= 0L) continue;
                satisfied = false;
                break;
            }
            if (!satisfied) continue;
            if (consumables.isEmpty()) {
                return limit;
            }
            int invMultiplier = Integer.MAX_VALUE;
            for (Object2LongMap.Entry cEntry : Object2LongMaps.fastIterable((Object2LongMap)consumables)) {
                Object2LongMap.Entry stackEntry;
                FluidIngredient ingredient = (FluidIngredient)cEntry.getKey();
                long needed = cEntry.getLongValue();
                long maxNeeded = needed * (long)limit;
                long available = 0L;
                ObjectIterator objectIterator = Object2LongMaps.fastIterable(group).iterator();
                while (objectIterator.hasNext() && (!ingredient.test((FluidStack)(stackEntry = (Object2LongMap.Entry)objectIterator.next()).getKey()) || (available += stackEntry.getLongValue()) < maxNeeded)) {
                }
                int ratio = GTMath.saturatedCast(Math.min((long)limit, available / needed));
                invMultiplier = Math.min(invMultiplier, ratio);
                if (ratio != 0) continue;
                break;
            }
            if (invMultiplier == limit) {
                return limit;
            }
            maxMultiplier = Math.max(maxMultiplier, invMultiplier);
        }
        return maxMultiplier;
    }

    private static List<Object2LongMap<FluidStack>> getInputContents(IRecipeCapabilityHolder holder) {
        List<RecipeHandlerList> handlerLists = holder.getCapabilitiesForIO(IO.IN);
        if (handlerLists.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<RecipeHandlerGroup, List<RecipeHandlerList>> handlerGroups = new HashMap<RecipeHandlerGroup, List<RecipeHandlerList>>();
        for (RecipeHandlerList handler : handlerLists) {
            if (!handler.hasCapability(CAP)) continue;
            RecipeHelper.addToRecipeHandlerMap(handler.getGroup(), handler, handlerGroups);
        }
        List distinctHandlerLists = handlerGroups.getOrDefault(RecipeHandlerGroupDistinctness.BUS_DISTINCT, Collections.emptyList());
        ArrayList<Object2LongMap<FluidStack>> invs = new ArrayList<Object2LongMap<FluidStack>>(distinctHandlerLists.size() + 1);
        for (RecipeHandlerList recipeHandlerList : distinctHandlerLists) {
            List<IRecipeHandler<?>> handlers = recipeHandlerList.getCapability(CAP);
            Object2LongOpenHashMap distinctInv = new Object2LongOpenHashMap();
            for (IRecipeHandler<?> handler : handlers) {
                for (Object object : handler.getContents()) {
                    FluidStack stack;
                    if (!(object instanceof FluidStack) || (stack = (FluidStack)object).isEmpty()) continue;
                    distinctInv.addTo((Object)stack, (long)stack.getAmount());
                }
            }
            if (distinctInv.isEmpty()) continue;
            invs.add((Object2LongMap<FluidStack>)distinctInv);
        }
        for (Map.Entry entry : handlerGroups.entrySet()) {
            if (entry.getKey() == RecipeHandlerGroupDistinctness.BUS_DISTINCT) continue;
            Object2LongOpenHashMap inventory = new Object2LongOpenHashMap();
            for (RecipeHandlerList handlerList : (List)entry.getValue()) {
                List<IRecipeHandler<?>> handlers = handlerList.getCapability(CAP);
                for (IRecipeHandler iRecipeHandler : handlers) {
                    for (Object content : iRecipeHandler.getContents()) {
                        FluidStack stack;
                        if (!(content instanceof FluidStack) || (stack = (FluidStack)content).isEmpty()) continue;
                        inventory.addTo((Object)stack, (long)stack.getAmount());
                    }
                }
            }
            if (inventory.isEmpty()) continue;
            invs.add((Object2LongMap<FluidStack>)inventory);
        }
        return invs;
    }

    @Override
    @NotNull
    public List<Object> createXEIContainerContents(List<Content> contents, GTRecipe recipe, IO io) {
        List<Object> entryLists = contents.stream().map(Content::getContent).map(this::of).map(FluidRecipeCapability::mapFluid).collect(Collectors.toList());
        while (entryLists.size() < recipe.recipeType.getMaxOutputs(this)) {
            entryLists.add(null);
        }
        return entryLists;
    }

    @Override
    public Object createXEIContainer(List<?> contents) {
        return new CycleFluidEntryHandler(contents);
    }

    @Override
    @NotNull
    public Widget createWidget() {
        TankWidget tank = new TankWidget();
        tank.initTemplate();
        tank.setFillDirection(ProgressTexture.FillDirection.ALWAYS_FULL);
        return tank;
    }

    @Override
    @NotNull
    public Class<? extends Widget> getWidgetClass() {
        return TankWidget.class;
    }

    @Override
    public void applyWidgetInfo(@NotNull Widget widget, int index, boolean isXEI, IO io,  @UnknownNullability(value="null when storage == null") GTRecipeTypeUI.RecipeHolder recipeHolder, @NotNull GTRecipeType recipeType, @UnknownNullability(value="null when content == null") GTRecipe recipe, @Nullable Content content, @Nullable Object storage, int recipeTier, int chanceTier) {
        if (widget instanceof TankWidget) {
            TankWidget tank = (TankWidget)widget;
            if (storage instanceof IFluidHandler) {
                IFluidHandler fluidHandler = (IFluidHandler)storage;
                tank.setFluidTank(fluidHandler, index);
            }
            tank.setIngredientIO(io == IO.IN ? IngredientIO.INPUT : IngredientIO.OUTPUT);
            tank.setAllowClickFilled(!isXEI);
            tank.setAllowClickDrained(!isXEI && io.support(IO.IN));
            if (isXEI) {
                tank.setShowAmount(false);
            }
            if (content != null) {
                float chance = (float)recipeType.getChanceFunction().getBoostedChance(content, recipeTier, chanceTier) / (float)content.maxChance;
                tank.setXEIChance(chance);
                tank.setOnAddedTooltips((w, tooltips) -> {
                    FluidIngredient ingredient = (FluidIngredient)CAP.of(content.content);
                    if (!isXEI && ingredient.getStacks().length > 0) {
                        FluidStack stack = ingredient.getStacks()[0];
                        TooltipsHandler.appendFluidTooltips(stack, tooltips::add, (TooltipFlag)TooltipFlag.f_256752_);
                    }
                    if (ingredient instanceof IntProviderFluidIngredient) {
                        IntProviderFluidIngredient provider = (IntProviderFluidIngredient)ingredient;
                        IntProvider countProvider = provider.getCountProvider();
                        tooltips.add(Component.m_237110_((String)"gtceu.gui.content.fluid_range", (Object[])new Object[]{countProvider.m_142739_(), countProvider.m_142737_()}).m_130940_(ChatFormatting.GOLD));
                    }
                    GTRecipeWidget.setConsumedChance(content, recipe.getChanceLogicForCapability(this, io, this.isTickSlot(index, io, recipe)), tooltips, recipeTier, chanceTier, recipeType.getChanceFunction());
                    if (this.isTickSlot(index, io, recipe)) {
                        tooltips.add(Component.m_237115_((String)"gtceu.gui.content.per_tick"));
                    }
                });
                if (io == IO.IN && content.chance == 0) {
                    tank.setIngredientIO(IngredientIO.CATALYST);
                }
            }
        }
    }

    public static FluidEntryList mapFluid(FluidIngredient ingredient) {
        int amount = ingredient instanceof IntProviderFluidIngredient ? 1 : ingredient.getAmount();
        CompoundTag tag = ingredient.getNbt();
        FluidTagList tags = new FluidTagList();
        FluidStackList fluids = new FluidStackList();
        for (FluidIngredient.Value value : ingredient.values) {
            if (value instanceof FluidIngredient.TagValue) {
                FluidIngredient.TagValue tagValue = (FluidIngredient.TagValue)value;
                tags.add(tagValue.tag(), amount, ingredient.getNbt());
                continue;
            }
            fluids.addAll(value.getFluids().stream().map(fluid -> new FluidStack(fluid, amount, tag)).toList());
        }
        if (!tags.isEmpty()) {
            return tags;
        }
        return fluids;
    }

    @Override
    public Object2IntMap<FluidIngredient> makeChanceCache() {
        return super.makeChanceCache();
    }

    @Override
    public boolean shouldBypassDistinct() {
        return false;
    }

    public static interface ICustomParallel {
        public int limitFluidParallel(GTRecipe var1, int var2, boolean var3);
    }
}

