/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability;

import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttribute;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttributes;
import com.gregtechceu.gtceu.api.fluids.attribute.IAttributedFluid;
import java.util.Collection;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public interface IThermalFluidHandlerItemStack {
    default public boolean canFillFluidType(FluidStack stack) {
        int temperature;
        if (stack == null || stack.getFluid() == null) {
            return false;
        }
        Fluid fluid = stack.getFluid();
        FluidType fluidType = fluid.getFluidType();
        if (fluidType.isLighterThanAir() && !this.isGasProof()) {
            return false;
        }
        if (fluid instanceof IAttributedFluid) {
            IAttributedFluid attributedFluid = (IAttributedFluid)fluid;
            Collection<FluidAttribute> attributes = attributedFluid.getAttributes();
            if (attributes.contains(FluidAttributes.ACID) && !this.isAcidProof()) {
                return false;
            }
            FluidState fluidState = attributedFluid.getState();
            if (fluidState == FluidState.PLASMA && !this.isPlasmaProof()) {
                return false;
            }
            if (fluidState == FluidState.GAS && !this.isGasProof()) {
                return false;
            }
        }
        if ((temperature = fluidType.getTemperature(stack)) < 120 && !this.isCryoProof()) {
            return false;
        }
        return temperature <= this.getMaxFluidTemperature();
    }

    public int getMaxFluidTemperature();

    public boolean isGasProof();

    public boolean isAcidProof();

    public boolean isCryoProof();

    public boolean isPlasmaProof();
}

