/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.setup;

import edivad.extrastorage.ExtraStorage;
import edivad.extrastorage.blockentity.AdvancedCrafterBlockEntity;
import edivad.extrastorage.blockentity.AdvancedExporterBlockEntity;
import edivad.extrastorage.blockentity.AdvancedFluidStorageBlockEntity;
import edivad.extrastorage.blockentity.AdvancedImporterBlockEntity;
import edivad.extrastorage.blockentity.AdvancedStorageBlockEntity;
import edivad.extrastorage.blocks.CrafterTier;
import edivad.extrastorage.container.AdvancedCrafterContainerMenu;
import edivad.extrastorage.container.AdvancedExporterContainerMenu;
import edivad.extrastorage.container.AdvancedFluidStorageBlockContainerMenu;
import edivad.extrastorage.container.AdvancedImporterContainerMenu;
import edivad.extrastorage.container.AdvancedStorageBlockContainerMenu;
import edivad.extrastorage.items.storage.fluid.FluidStorageType;
import edivad.extrastorage.items.storage.item.ItemStorageType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ESContainer {
    public static final Map<ItemStorageType, RegistryObject<MenuType<AdvancedStorageBlockContainerMenu>>> ITEM_STORAGE = new HashMap<ItemStorageType, RegistryObject<MenuType<AdvancedStorageBlockContainerMenu>>>();
    public static final Map<FluidStorageType, RegistryObject<MenuType<AdvancedFluidStorageBlockContainerMenu>>> FLUID_STORAGE = new HashMap<FluidStorageType, RegistryObject<MenuType<AdvancedFluidStorageBlockContainerMenu>>>();
    public static final Map<CrafterTier, RegistryObject<MenuType<AdvancedCrafterContainerMenu>>> CRAFTER = new HashMap<CrafterTier, RegistryObject<MenuType<AdvancedCrafterContainerMenu>>>();
    private static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"extrastorage");
    public static final RegistryObject<MenuType<AdvancedExporterContainerMenu>> ADVANCED_EXPORTER = CONTAINERS.register("advanced_exporter", () -> IForgeMenuType.create((windowId, inv, data) -> {
        BlockPos pos = data.m_130135_();
        BlockEntity blockEntity = inv.f_35978_.m_20193_().m_7702_(pos);
        if (!(blockEntity instanceof AdvancedExporterBlockEntity)) {
            ExtraStorage.LOGGER.error("Wrong type of blockentity (expected AdvancedExporterBlockEntity)!");
            return null;
        }
        AdvancedExporterBlockEntity be = (AdvancedExporterBlockEntity)blockEntity;
        return new AdvancedExporterContainerMenu(windowId, inv.f_35978_, be);
    }));
    public static final RegistryObject<MenuType<AdvancedImporterContainerMenu>> ADVANCED_IMPORTER = CONTAINERS.register("advanced_importer", () -> IForgeMenuType.create((windowId, inv, data) -> {
        BlockPos pos = data.m_130135_();
        BlockEntity blockEntity = inv.f_35978_.m_20193_().m_7702_(pos);
        if (!(blockEntity instanceof AdvancedImporterBlockEntity)) {
            ExtraStorage.LOGGER.error("Wrong type of blockentity (expected AdvancedImporterBlockEntity)!");
            return null;
        }
        AdvancedImporterBlockEntity be = (AdvancedImporterBlockEntity)blockEntity;
        return new AdvancedImporterContainerMenu(windowId, inv.f_35978_, be);
    }));

    public static void register(IEventBus modEventBus) {
        CONTAINERS.register(modEventBus);
    }

    static {
        for (ItemStorageType itemStorageType : ItemStorageType.values()) {
            ITEM_STORAGE.put(itemStorageType, (RegistryObject<MenuType<AdvancedStorageBlockContainerMenu>>)CONTAINERS.register("block_" + itemStorageType.getName(), () -> IForgeMenuType.create((windowId, inv, data) -> {
                BlockPos pos = data.m_130135_();
                BlockEntity blockEntity = inv.f_35978_.m_20193_().m_7702_(pos);
                if (!(blockEntity instanceof AdvancedStorageBlockEntity)) {
                    ExtraStorage.LOGGER.error("Wrong type of blockentity (expected AdvancedStorageBlockEntity)!");
                    return null;
                }
                AdvancedStorageBlockEntity be = (AdvancedStorageBlockEntity)blockEntity;
                return new AdvancedStorageBlockContainerMenu(windowId, inv.f_35978_, be);
            })));
        }
        for (Enum enum_ : FluidStorageType.values()) {
            FLUID_STORAGE.put((FluidStorageType)enum_, (RegistryObject<MenuType<AdvancedFluidStorageBlockContainerMenu>>)CONTAINERS.register("block_" + ((FluidStorageType)enum_).getName() + "_fluid", () -> IForgeMenuType.create((windowId, inv, data) -> {
                BlockPos pos = data.m_130135_();
                BlockEntity blockEntity = inv.f_35978_.m_20193_().m_7702_(pos);
                if (!(blockEntity instanceof AdvancedFluidStorageBlockEntity)) {
                    ExtraStorage.LOGGER.error("Wrong type of blockentity (expected AdvancedFluidStorageBlockEntity)!");
                    return null;
                }
                AdvancedFluidStorageBlockEntity be = (AdvancedFluidStorageBlockEntity)blockEntity;
                return new AdvancedFluidStorageBlockContainerMenu(windowId, inv.f_35978_, be);
            })));
        }
        for (Enum enum_ : CrafterTier.values()) {
            CRAFTER.put((CrafterTier)enum_, (RegistryObject<MenuType<AdvancedCrafterContainerMenu>>)CONTAINERS.register(((CrafterTier)enum_).getID(), () -> IForgeMenuType.create((windowId, inv, data) -> {
                BlockPos pos = data.m_130135_();
                BlockEntity blockEntity = inv.f_35978_.m_20193_().m_7702_(pos);
                if (!(blockEntity instanceof AdvancedCrafterBlockEntity)) {
                    ExtraStorage.LOGGER.error("Wrong type of blockentity (expected AdvancedCrafterBlockEntity)!");
                    return null;
                }
                AdvancedCrafterBlockEntity be = (AdvancedCrafterBlockEntity)blockEntity;
                return new AdvancedCrafterContainerMenu(windowId, inv.f_35978_, be);
            })));
        }
    }
}

