/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.common.network;

import cofh.lib.common.network.packet.IPacket;
import cofh.lib.common.network.packet.IPacketClient;
import cofh.lib.common.network.packet.IPacketServer;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.logging.log4j.Logger;

public class PacketHandler {
    private final ResourceLocation channelName;
    private final EventNetworkChannel channel;
    private final Byte2ObjectMap<Supplier<IPacket>> packets = new Byte2ObjectArrayMap(255);
    private final Logger log;

    public PacketHandler(ResourceLocation channelName, Logger log) {
        this.channelName = channelName;
        this.log = log;
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName).networkProtocolVersion(() -> Integer.toString(1)).clientAcceptedVersions(e -> true).serverAcceptedVersions(e -> true).eventNetworkChannel();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.channel.registerObject((Object)new ClientHandler());
        }
        this.channel.registerObject((Object)new ServerHandler());
    }

    public <T extends IPacket> void registerPacket(int id, Supplier<? super T> constructor) {
        if (id <= 0 || id >= 255) {
            throw new IllegalArgumentException(String.format("Packet id(%s) not within bounds id <= 0 || id >= 255", id));
        }
        this.packets.put((byte)id, constructor);
        this.log.debug("Channel {}, Register packet, ID: {}", (Object)this.channelName, (Object)id);
    }

    public ResourceLocation getChannelName() {
        return this.channelName;
    }

    public Logger log() {
        return this.log;
    }

    private class ClientHandler {
        private ClientHandler() {
        }

        @SubscribeEvent
        public void onPayload(NetworkEvent.ServerCustomPayloadEvent event) {
            ByteBuf payload = event.getPayload().copy();
            FriendlyByteBuf buf = new FriendlyByteBuf(payload);
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            ctx.setPacketHandled(true);
            byte id = (byte)buf.readUnsignedByte();
            Supplier supplier = (Supplier)PacketHandler.this.packets.get(id);
            if (supplier == null) {
                PacketHandler.this.log.error("Received unregistered packet! ID: {}, Side: Client", (Object)id);
                return;
            }
            IPacket packet = (IPacket)supplier.get();
            if (!(packet instanceof IPacketClient)) {
                PacketHandler.this.log.error("Received packet ID that isn't an IPacketClient? ID: {}", (Object)id);
                return;
            }
            packet.read(buf);
            ctx.enqueueWork(() -> {
                try {
                    ((IPacketClient)packet).handleClient();
                }
                catch (Throwable ex) {
                    PacketHandler.this.log.error("Error handling packet on channel {}.", (Object)PacketHandler.this.channelName, (Object)ex);
                }
                finally {
                    buf.release();
                }
            });
        }
    }

    private class ServerHandler {
        private ServerHandler() {
        }

        @SubscribeEvent
        public void onPayload(NetworkEvent.ClientCustomPayloadEvent event) {
            ByteBuf payload = event.getPayload().copy();
            FriendlyByteBuf buf = new FriendlyByteBuf(payload);
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            ctx.setPacketHandled(true);
            byte id = (byte)buf.readUnsignedByte();
            Supplier supplier = (Supplier)PacketHandler.this.packets.get(id);
            if (supplier == null) {
                PacketHandler.this.log.error("Received unregistered packet! ID: {}, Side: Server", (Object)id);
                return;
            }
            IPacket packet = (IPacket)supplier.get();
            if (!(packet instanceof IPacketServer)) {
                PacketHandler.this.log.error("Received packet ID that isn't an IPacketServer? ID: {}", (Object)id);
                return;
            }
            packet.read(buf);
            PacketListener netHandler = ctx.getNetworkManager().m_129538_();
            if (netHandler instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl gamePacketListener = (ServerGamePacketListenerImpl)netHandler;
                ctx.enqueueWork(() -> {
                    try {
                        ((IPacketServer)packet).handleServer(gamePacketListener.f_9743_);
                    }
                    catch (Throwable ex) {
                        PacketHandler.this.log.error("Error handling packet on channel {}.", (Object)PacketHandler.this.channelName, (Object)ex);
                    }
                    finally {
                        buf.release();
                    }
                });
            }
        }
    }
}

