/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.common.block;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class QuicksandBlock
extends Block
implements BucketPickup {
    protected static final float IN_BLOCK_HORIZONTAL_SPEED_MULTIPLIER = 0.4f;
    protected static final float IN_BLOCK_VERTICAL_SPEED_MULTIPLIER = 0.2f;
    protected static final float NUM_BLOCKS_TO_FALL_INTO_BLOCK = 2.5f;
    protected static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9, (double)1.0);
    protected static final double MINIMUM_FALL_DISTANCE_FOR_SOUND = 4.0;
    protected static final double MINIMUM_FALL_DISTANCE_FOR_BIG_SOUND = 7.0;
    protected Supplier<Item> bucket = () -> Items.f_41852_;

    public QuicksandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public QuicksandBlock bucket(Supplier<Item> bucket) {
        this.bucket = bucket;
        return this;
    }

    public boolean m_6104_(BlockState state, BlockState otherState, Direction face) {
        return otherState.m_60713_((Block)this) || super.m_6104_(state, otherState, face);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.m_146900_().m_60713_((Block)this)) {
            entity.m_7601_(state, new Vec3((double)0.4f, (double)0.2f, (double)0.4f));
        }
        if (!level.f_46443_) {
            entity.m_146868_(false);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float distance) {
        if (!((double)distance < 4.0) && entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            LivingEntity.Fallsounds fallSounds = livingentity.m_196493_();
            SoundEvent soundevent = (double)distance < 7.0 ? fallSounds.f_196626_() : fallSounds.f_196627_();
            entity.m_5496_(soundevent, 1.0f, 1.0f);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext entitycollisioncontext;
        Entity entity;
        if (collisionContext instanceof EntityCollisionContext && (entity = (entitycollisioncontext = (EntityCollisionContext)collisionContext).m_193113_()) != null) {
            if (entity.f_19789_ > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            if (entity instanceof FallingBlockEntity || QuicksandBlock.canEntityWalkOnQuicksand(entity) && collisionContext.m_6513_(Shapes.m_83144_(), pos, false)) {
                return super.m_5939_(state, blockGetter, pos, collisionContext);
            }
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return Shapes.m_83040_();
    }

    public static boolean canEntityWalkOnQuicksand(Entity entity) {
        double delX = entity.m_20184_().f_82479_;
        double delZ = entity.m_20184_().f_82481_;
        if (delX > 0.0 && delZ > 0.0) {
            System.out.println(delX);
            System.out.println(delZ);
        }
        return entity instanceof LivingEntity && delX * delX + delZ * delZ < 0.025;
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        levelAccessor.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        if (!levelAccessor.m_5776_()) {
            levelAccessor.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        return new ItemStack((ItemLike)this.bucket.get());
    }

    public Optional<SoundEvent> m_142298_() {
        return Optional.empty();
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType type) {
        return true;
    }
}

