/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.pets;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;

public abstract class BasePetEnderman
extends BaseEnderman
implements GeoEntity,
OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(BasePetEnderman.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private EndermanHurtByTargetGoal hurtByTargetGoal;

    public BasePetEnderman(EntityType<? extends BaseEnderman> entityType, Level level) {
        super(entityType, level);
    }

    public BasePetEnderman(EntityType<? extends BaseEnderman> entityType, Level level, Player owner) {
        super(entityType, level);
        this.setOwnerUUID(owner.m_20148_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 5, state -> {
            if (state.isMoving()) {
                state.getController().setAnimation(this.m_32531_() ? ConstantAnimations.RUN : ConstantAnimations.WALK);
            } else {
                state.getController().setAnimation(ConstantAnimations.IDLE);
            }
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack_controller", 5, state -> {
            if (!this.playArmSwingAnimWhenAttacking()) {
                return PlayState.STOP;
            }
            if (this.m_21324_(state.getPartialTick()) == 0.0f) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ATTACK);
            return PlayState.CONTINUE;
        })});
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new EndermanFollowOwnerGoal(1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new EndermanOwnerHurtByTargetGoal());
        this.f_21346_.m_25352_(2, (Goal)new EndermanOwnerHurtTargetGoal());
        this.hurtByTargetGoal = new EndermanHurtByTargetGoal(new Class[0]);
        this.f_21346_.m_25352_(3, (Goal)this.hurtByTargetGoal);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String string = compound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)Objects.requireNonNull(this.m_20194_()), (String)string);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    public boolean m_6573_(@NotNull Player player) {
        return !this.m_21523_();
    }

    @Override
    public void m_8119_() {
        Player p;
        BasePetEnderman e;
        LivingEntity livingEntity;
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && (livingEntity = this.m_5448_()) instanceof BasePetEnderman && Objects.equals((e = (BasePetEnderman)livingEntity).m_21805_(), this.m_21805_())) {
            this.m_6710_(null);
            this.m_6703_(null);
        }
        if (!this.m_9236_().m_5776_() && (livingEntity = this.m_5448_()) instanceof Player && (p = (Player)livingEntity).m_20148_().equals(this.m_21805_())) {
            this.m_6710_(null);
            this.m_6703_(null);
        }
    }

    @Override
    @Nullable
    public ParticleOptions getCustomParticles() {
        return (ParticleOptions)ModParticleTypes.FRIENDERMAN.get();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.f_19797_ % 2000 == 0) {
            this.m_5634_(1.0f);
        }
    }

    public boolean wantsToAttack(LivingEntity target) {
        if (target instanceof Creeper) {
            return false;
        }
        if (target instanceof Ghast) {
            return false;
        }
        if (target instanceof BasePetEnderman) {
            BasePetEnderman otherPet = (BasePetEnderman)target;
            return !Objects.equals(otherPet.m_21805_(), this.m_21805_());
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            return !player.m_20148_().equals(this.m_21805_());
        }
        return true;
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
            this.m_269323_().m_213846_(this.m_21231_().m_19293_());
        }
        super.m_6667_(damageSource);
    }

    @Override
    public boolean isProvokedByEyeContact() {
        return false;
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!player.m_20148_().equals(this.m_21805_())) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().m_5776_()) {
            CompoundTag entityTag = new CompoundTag();
            CompoundTag petTag = new CompoundTag();
            this.m_20240_(petTag);
            ItemStack pearl = ((Item)ModItems.ANCIENT_PEARL.get()).m_7968_();
            entityTag.m_128365_("PetEntity", (Tag)petTag);
            entityTag.m_128359_("PetType", BuiltInRegistries.f_256780_.m_7981_((Object)this.m_6095_()).m_135815_());
            pearl.m_41751_(entityTag);
            BehaviorUtils.m_22613_((LivingEntity)this, (ItemStack)pearl, (Vec3)this.m_20182_());
            this.m_216990_(SoundEvents.f_11852_);
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        for (int i = 0; i < this.getParticleCount(); ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    public class EndermanFollowOwnerGoal
    extends Goal {
        private LivingEntity owner;
        private final LevelReader level;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;
        private final boolean canFly;

        public EndermanFollowOwnerGoal(double d, float f, float g, boolean bl) {
            this.level = BasePetEnderman.this.m_9236_();
            this.speedModifier = d;
            this.navigation = BasePetEnderman.this.m_21573_();
            this.startDistance = f;
            this.stopDistance = g;
            this.canFly = bl;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(BasePetEnderman.this.m_21573_() instanceof GroundPathNavigation) && !(BasePetEnderman.this.m_21573_() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = BasePetEnderman.this.m_269323_();
            if (livingEntity == null) {
                return false;
            }
            if (livingEntity.m_5833_()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            if (BasePetEnderman.this.m_20280_((Entity)livingEntity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            this.owner = livingEntity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            return !(BasePetEnderman.this.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
        }

        private boolean unableToMove() {
            return BasePetEnderman.this.m_20159_() || BasePetEnderman.this.m_21523_();
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = BasePetEnderman.this.m_21439_(BlockPathTypes.WATER);
            BasePetEnderman.this.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
            BasePetEnderman.this.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            BasePetEnderman.this.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)BasePetEnderman.this.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                if (BasePetEnderman.this.m_20280_((Entity)this.owner) >= Math.pow(20.0, 2.0)) {
                    this.teleportToOwner();
                } else {
                    this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
                }
            }
        }

        private void teleportToOwner() {
            BlockPos blockPos = this.owner.m_20183_();
            for (int i = 0; i < 10; ++i) {
                int j = this.randomIntInclusive(-3, 3);
                int k = this.randomIntInclusive(-1, 1);
                int l = this.randomIntInclusive(-3, 3);
                boolean teleported = this.maybeTeleportTo(blockPos.m_123341_() + j, blockPos.m_123342_() + k, blockPos.m_123343_() + l);
                if (!teleported) continue;
                return;
            }
        }

        private boolean maybeTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(x, y, z))) {
                return false;
            }
            BasePetEnderman.this.m_7678_((double)x + 0.5, y, (double)z + 0.5, BasePetEnderman.this.m_146908_(), BasePetEnderman.this.m_146909_());
            this.navigation.m_26573_();
            return true;
        }

        private boolean canTeleportTo(BlockPos pos) {
            BlockPathTypes blockPathTypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
            if (blockPathTypes != BlockPathTypes.WALKABLE) {
                return false;
            }
            BlockState blockState = this.level.m_8055_(pos.m_7495_());
            if (!this.canFly && blockState.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockPos = pos.m_121996_((Vec3i)BasePetEnderman.this.m_20183_());
            return this.level.m_45756_((Entity)BasePetEnderman.this, BasePetEnderman.this.m_20191_().m_82338_(blockPos));
        }

        private int randomIntInclusive(int min, int max) {
            return BasePetEnderman.this.m_217043_().m_188503_(max - min + 1) + min;
        }
    }

    public class EndermanOwnerHurtByTargetGoal
    extends TargetGoal {
        private LivingEntity ownerLastHurtBy;
        private int timestamp;

        public EndermanOwnerHurtByTargetGoal() {
            super((Mob)BasePetEnderman.this, false);
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = BasePetEnderman.this.m_269323_();
            if (livingEntity == null) {
                return false;
            }
            this.ownerLastHurtBy = livingEntity.m_21188_();
            int i = livingEntity.m_21213_();
            return i != this.timestamp && this.m_26150_(this.ownerLastHurtBy, TargetingConditions.f_26872_) && BasePetEnderman.this.wantsToAttack(this.ownerLastHurtBy);
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.ownerLastHurtBy);
            LivingEntity livingEntity = BasePetEnderman.this.m_269323_();
            if (livingEntity != null) {
                this.timestamp = livingEntity.m_21213_();
            }
            super.m_8056_();
        }
    }

    public class EndermanOwnerHurtTargetGoal
    extends TargetGoal {
        private LivingEntity ownerLastHurt;
        private int timestamp;

        public EndermanOwnerHurtTargetGoal() {
            super((Mob)BasePetEnderman.this, false);
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = BasePetEnderman.this.m_269323_();
            if (livingEntity == null) {
                return false;
            }
            this.ownerLastHurt = livingEntity.m_21214_();
            int i = livingEntity.m_21215_();
            return i != this.timestamp && this.m_26150_(this.ownerLastHurt, TargetingConditions.f_26872_) && BasePetEnderman.this.wantsToAttack(this.ownerLastHurt);
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.ownerLastHurt);
            LivingEntity livingEntity = BasePetEnderman.this.m_269323_();
            if (livingEntity != null) {
                this.timestamp = livingEntity.m_21215_();
            }
            super.m_8056_();
        }
    }

    public class EndermanHurtByTargetGoal
    extends TargetGoal {
        private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
        private int timestamp;
        private final Class<?>[] toIgnoreDamage;

        public EndermanHurtByTargetGoal(Class<?> ... classes) {
            super((Mob)BasePetEnderman.this, true);
            this.toIgnoreDamage = classes;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            int i = BasePetEnderman.this.m_21213_();
            LivingEntity livingEntity = BasePetEnderman.this.m_21188_();
            if (i != this.timestamp && livingEntity != null) {
                if (livingEntity.m_6095_() == EntityType.f_20532_ && BasePetEnderman.this.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
                    return false;
                }
                if (!BasePetEnderman.this.wantsToAttack(livingEntity)) {
                    return false;
                }
                for (Class<?> clazz : this.toIgnoreDamage) {
                    if (!clazz.isAssignableFrom(livingEntity.getClass())) continue;
                    return false;
                }
                return this.m_26150_(livingEntity, HURT_BY_TARGETING);
            }
            return false;
        }

        public void m_8056_() {
            BasePetEnderman.this.m_6710_(BasePetEnderman.this.m_21188_());
            this.f_26137_ = BasePetEnderman.this.m_5448_();
            this.timestamp = BasePetEnderman.this.m_21213_();
            this.f_26138_ = 300;
            this.alertOthers();
            super.m_8056_();
        }

        public void notifyStart() {
            BasePetEnderman.this.m_6710_(BasePetEnderman.this.m_21188_());
            this.f_26137_ = BasePetEnderman.this.m_5448_();
            this.timestamp = BasePetEnderman.this.m_21213_();
            this.f_26138_ = 300;
            super.m_8056_();
        }

        public void alertOthers() {
            Player p;
            UUID owner = BasePetEnderman.this.m_21805_();
            if (owner == null) {
                return;
            }
            LivingEntity targetMob = BasePetEnderman.this.m_5448_();
            if (targetMob instanceof Player && (p = (Player)targetMob).m_20148_().equals(owner)) {
                return;
            }
            if (targetMob == null) {
                return;
            }
            AABB aabb = AABB.m_82333_((Vec3)BasePetEnderman.this.m_20182_()).m_82400_(30.0);
            List pets = BasePetEnderman.this.m_9236_().m_6443_(BasePetEnderman.class, aabb, EntitySelector.f_20408_);
            pets.remove((Object)BasePetEnderman.this);
            List<BasePetEnderman> ownedPets = pets.stream().filter(pet -> owner.equals(pet.m_21805_())).toList();
            if (ownedPets.size() <= 1) {
                return;
            }
            ArrayList<BasePetEnderman> targets = new ArrayList<BasePetEnderman>();
            if (targetMob instanceof BasePetEnderman) {
                BasePetEnderman target = (BasePetEnderman)targetMob;
                UUID targetOwner = target.m_21805_();
                if (targetOwner == null) {
                    return;
                }
                targets.addAll(pets.stream().filter(pet -> targetOwner.equals(pet.m_21805_())).toList());
                Player player = BasePetEnderman.this.m_9236_().m_46003_(targetOwner);
                if (player != null && player.m_20270_((Entity)BasePetEnderman.this) < 30.0f) {
                    targets.add((BasePetEnderman)player);
                }
                if (targets.isEmpty()) {
                    return;
                }
            } else if (targetMob instanceof Player) {
                Player player = (Player)targetMob;
                targets.add((BasePetEnderman)player);
                targets.addAll(pets.stream().filter(pet -> player.m_20148_().equals(pet.m_21805_())).toList());
            } else {
                AABB aabb2 = AABB.m_82333_((Vec3)BasePetEnderman.this.m_20182_()).m_82400_(20.0);
                targets.addAll(BasePetEnderman.this.m_9236_().m_6443_(targetMob.getClass(), aabb2, EntitySelector.f_20408_));
            }
            for (BasePetEnderman pet2 : ownedPets) {
                LivingEntity closestTarget = targets.stream().min(Comparator.comparingDouble(arg_0 -> ((BasePetEnderman)pet2).m_20280_(arg_0))).orElse(null);
                pet2.m_6703_(closestTarget);
                pet2.hurtByTargetGoal.notifyStart();
            }
        }
    }
}

