/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.TargetIterator;
import com.yogpc.qp.machines.TraceQuarryWork;
import com.yogpc.qp.machines.advquarry.AdvQuarry;
import com.yogpc.qp.machines.advquarry.TileAdvQuarry;
import com.yogpc.qp.machines.filler.FillerAction;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class AdvQuarryAction
implements BlockEntityTicker<TileAdvQuarry> {
    static final Map<String, Serializer> SERIALIZER_MAP = Stream.of(new WaitingSerializer(), new MakeFrameSerializer(), new BreakBlockSerializer(), new CheckFluidSerializer(), new FillerWorkSerializer(), new FinishedSerializer()).collect(Collectors.toMap(Serializer::key, Function.identity()));

    final CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", this.key());
        return this.writeDetail(tag);
    }

    static AdvQuarryAction fromNbt(CompoundTag tag, TileAdvQuarry quarry) {
        String key = tag.m_128461_("type");
        return Optional.ofNullable(SERIALIZER_MAP.get(key)).map(s -> s.fromTag(tag, quarry)).orElseGet(() -> {
            if (!tag.m_128456_()) {
                AdvQuarry.LOGGER.error(AdvQuarry.ACTION, "Unknown type '{}' found in tag: {}", (Object)key, (Object)tag);
            }
            return Waiting.WAITING;
        });
    }

    abstract CompoundTag writeDetail(CompoundTag var1);

    abstract String key();

    public String toString() {
        return this.key();
    }

    public abstract void tick(Level var1, BlockPos var2, BlockState var3, TileAdvQuarry var4);

    abstract double getProgress(TileAdvQuarry var1);

    private static double getProgressOfIterator(TargetIterator newIterator, TargetIterator.XZPair current) {
        int count = 1;
        int index = 0;
        while (newIterator.hasNext()) {
            TargetIterator.XZPair t = (TargetIterator.XZPair)newIterator.next();
            if (t.equals(current)) {
                index = count;
            }
            ++count;
        }
        return (double)index / (double)count;
    }

    @Nullable
    static <T> T skipIterator(Iterator<T> iterator, Predicate<T> skipCondition) {
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (skipCondition.test(next)) continue;
            return next;
        }
        return null;
    }

    TargetIterator createTargetIterator(Area area, boolean chunkByChunk) {
        return TargetIterator.of(area, chunkByChunk);
    }

    boolean isChunkUnavailableAtPos(Level level, BlockPos pos) {
        if (!level.m_46805_(pos)) {
            AdvQuarry.LOGGER.fatal(AdvQuarry.ACTION, "[{}] Chunk doesn't exist in {}", (Object)this.key(), (Object)pos);
            return true;
        }
        return false;
    }

    static void startQuarry(TileAdvQuarry quarry) {
        if (quarry.workConfig.placeAreaFrame()) {
            quarry.setAction(new MakeFrame(quarry.getArea()));
        } else {
            quarry.setAction(new BreakBlock(quarry));
        }
        TraceQuarryWork.startWork(quarry, quarry.m_58899_(), quarry.getEnergyStored());
    }

    static abstract class Serializer {
        Serializer() {
        }

        abstract String key();

        abstract AdvQuarryAction fromTag(CompoundTag var1, TileAdvQuarry var2);
    }

    public static final class MakeFrame
    extends AdvQuarryAction {
        private Iterator<BlockPos> posIterator;
        @Nullable
        private BlockPos current;

        public MakeFrame(Area area) {
            this.posIterator = Area.getFramePosStream(area).iterator();
            this.current = this.posIterator.next();
        }

        MakeFrame(Area area, @Nullable BlockPos current) {
            this.posIterator = Area.getFramePosStream(area).dropWhile(Predicate.isEqual(current).negate()).iterator();
            if (!this.posIterator.hasNext()) {
                this.posIterator = Area.getFramePosStream(area).iterator();
                this.current = this.posIterator.next();
            } else {
                this.current = current;
            }
        }

        @Override
        CompoundTag writeDetail(CompoundTag tag) {
            if (this.current != null) {
                tag.m_128356_("current", this.current.m_121878_());
            }
            return tag;
        }

        @Override
        String key() {
            return "MakeFrame";
        }

        @Override
        public void tick(Level level, BlockPos pos, BlockState state, TileAdvQuarry quarry) {
            for (int i = 0; i < 4; ++i) {
                if (this.current != null) {
                    BlockState targetState = quarry.getTargetWorld().m_8055_(this.current);
                    BreakResult result = targetState.m_60795_() ? BreakResult.SUCCESS : quarry.breakOneBlock(this.current, true);
                    if (!result.isSuccess()) continue;
                    if (result == BreakResult.FAIL_EVENT || result == BreakResult.SKIPPED) {
                        this.current = MakeFrame.skipIterator(this.posIterator, MakeFrame.skipFramePlace(quarry));
                        continue;
                    }
                    if (!quarry.useEnergy(PowerManager.getMakeFrameEnergy(quarry), PowerTile.Reason.MAKE_FRAME, false)) continue;
                    quarry.getTargetWorld().m_46597_(this.current, Holder.BLOCK_FRAME.m_49966_());
                    this.current = MakeFrame.skipIterator(this.posIterator, MakeFrame.skipFramePlace(quarry));
                    continue;
                }
                quarry.setAction(new BreakBlock(quarry));
                break;
            }
        }

        @Override
        double getProgress(TileAdvQuarry quarry) {
            if (this.current == null || quarry.getArea() == null) {
                return 1.0;
            }
            List<BlockPos> poses = Area.getFramePosStream(quarry.getArea()).toList();
            int index = poses.indexOf(this.current) + 1;
            return (double)index / (double)poses.size();
        }

        static Predicate<BlockPos> skipFramePlace(TileAdvQuarry quarry) {
            ServerLevel world = quarry.getTargetWorld();
            assert (world != null);
            return pos -> {
                BlockState state = world.m_8055_(pos);
                return state.m_60713_((Block)Holder.BLOCK_FRAME) || !quarry.canBreak((Level)world, (BlockPos)pos, state) || pos.equals((Object)quarry.m_58899_());
            };
        }
    }

    public static final class BreakBlock
    extends AdvQuarryAction {
        private final TargetIterator iterator;
        private boolean searchEnergyConsumed;

        public BreakBlock(TileAdvQuarry quarry) {
            assert (quarry.getArea() != null);
            this.iterator = this.createTargetIterator(quarry.getArea(), quarry.workConfig.chunkByChunk());
        }

        BreakBlock(TileAdvQuarry quarry, int x, int z, boolean searchEnergyConsumed) {
            assert (quarry.getArea() != null);
            this.iterator = this.createTargetIterator(quarry.getArea(), quarry.workConfig.chunkByChunk());
            this.iterator.setCurrent(new TargetIterator.XZPair(x, z));
            this.searchEnergyConsumed = searchEnergyConsumed;
        }

        @Override
        CompoundTag writeDetail(CompoundTag tag) {
            TargetIterator.XZPair xzPair = (TargetIterator.XZPair)this.iterator.peek();
            tag.m_128405_("currentX", xzPair.x());
            tag.m_128405_("currentZ", xzPair.z());
            tag.m_128379_("searchEnergyConsumed", this.searchEnergyConsumed);
            return tag;
        }

        @Override
        String key() {
            return "BreakBlock";
        }

        @Override
        public void tick(Level level, BlockPos pos, BlockState state, TileAdvQuarry quarry) {
            BreakResult result = null;
            while (result == null || result == BreakResult.SKIPPED) {
                TargetIterator.XZPair target = (TargetIterator.XZPair)this.iterator.peek();
                if (!this.searchEnergyConsumed) {
                    long energy = PowerManager.getAdvSearchEnergy(pos.m_123342_() - quarry.digMinY, quarry);
                    this.searchEnergyConsumed = quarry.useEnergy(energy, PowerTile.Reason.ADV_SEARCH, false);
                }
                if (!this.searchEnergyConsumed) break;
                result = quarry.breakBlocks(target.x(), target.z());
                if (!result.isSuccess()) continue;
                this.iterator.next();
                this.searchEnergyConsumed = false;
                if (this.iterator.hasNext()) continue;
                if (((Boolean)QuarryPlus.config.common.removeFluidAfterFinishedByCD.get()).booleanValue()) {
                    quarry.setAction(new CheckFluid(quarry));
                    break;
                }
                if (quarry.hasFillerModule()) {
                    quarry.setAction(new FillerWork(quarry));
                    break;
                }
                quarry.setAction(Finished.FINISHED);
                break;
            }
        }

        @Override
        double getProgress(TileAdvQuarry quarry) {
            if (quarry.getArea() == null) {
                return 1.0;
            }
            TargetIterator iterator = this.createTargetIterator(quarry.getArea(), quarry.workConfig.chunkByChunk());
            return AdvQuarryAction.getProgressOfIterator(iterator, (TargetIterator.XZPair)this.iterator.peek());
        }
    }

    public static final class Waiting
    extends AdvQuarryAction {
        public static final Waiting WAITING = new Waiting();

        private Waiting() {
        }

        @Override
        String key() {
            return "Waiting";
        }

        @Override
        CompoundTag writeDetail(CompoundTag tag) {
            return new CompoundTag();
        }

        @Override
        public void tick(Level level, BlockPos pos, BlockState state, TileAdvQuarry quarry) {
            if (quarry.getEnergy() > quarry.getMaxEnergy() / 4L && quarry.canStartWork()) {
                Waiting.startQuarry(quarry);
            }
        }

        @Override
        double getProgress(TileAdvQuarry quarry) {
            return 1.0;
        }
    }

    private static final class WaitingSerializer
    extends Serializer {
        private WaitingSerializer() {
        }

        @Override
        String key() {
            return "Waiting";
        }

        @Override
        AdvQuarryAction fromTag(CompoundTag tag, TileAdvQuarry quarry) {
            return Waiting.WAITING;
        }
    }

    private static final class MakeFrameSerializer
    extends Serializer {
        private MakeFrameSerializer() {
        }

        @Override
        String key() {
            return "MakeFrame";
        }

        @Override
        AdvQuarryAction fromTag(CompoundTag tag, TileAdvQuarry quarry) {
            BlockPos pos = tag.m_128441_("current") ? BlockPos.m_122022_((long)tag.m_128454_("current")) : null;
            return new MakeFrame(quarry.getArea(), pos);
        }
    }

    private static final class BreakBlockSerializer
    extends Serializer {
        private BreakBlockSerializer() {
        }

        @Override
        String key() {
            return "BreakBlock";
        }

        @Override
        AdvQuarryAction fromTag(CompoundTag tag, TileAdvQuarry quarry) {
            int x = tag.m_128451_("currentX");
            int z = tag.m_128451_("currentZ");
            boolean searchEnergyConsumed = tag.m_128471_("searchEnergyConsumed");
            return new BreakBlock(quarry, x, z, searchEnergyConsumed);
        }
    }

    private static final class CheckFluidSerializer
    extends Serializer {
        private CheckFluidSerializer() {
        }

        @Override
        String key() {
            return "CheckFluid";
        }

        @Override
        AdvQuarryAction fromTag(CompoundTag tag, TileAdvQuarry quarry) {
            int x = tag.m_128451_("currentX");
            int z = tag.m_128451_("currentZ");
            return new CheckFluid(quarry, x, z);
        }
    }

    private static final class FillerWorkSerializer
    extends Serializer {
        private FillerWorkSerializer() {
        }

        @Override
        String key() {
            return "FillerWork";
        }

        @Override
        FillerWork fromTag(CompoundTag tag, TileAdvQuarry quarry) {
            int x = tag.m_128451_("currentX");
            int z = tag.m_128451_("currentZ");
            return new FillerWork(quarry, x, z);
        }
    }

    private static final class FinishedSerializer
    extends Serializer {
        private FinishedSerializer() {
        }

        @Override
        String key() {
            return "Finished";
        }

        @Override
        AdvQuarryAction fromTag(CompoundTag tag, TileAdvQuarry quarry) {
            return Finished.FINISHED;
        }
    }

    public static final class FillerWork
    extends AdvQuarryAction {
        private final TargetIterator iterator;

        public FillerWork(TileAdvQuarry quarry) {
            assert (quarry.getArea() != null);
            this.iterator = this.createTargetIterator(quarry.getArea(), quarry.workConfig.chunkByChunk());
        }

        FillerWork(TileAdvQuarry quarry, int x, int z) {
            assert (quarry.getArea() != null);
            this.iterator = this.createTargetIterator(quarry.getArea(), quarry.workConfig.chunkByChunk());
            this.iterator.setCurrent(new TargetIterator.XZPair(x, z));
        }

        @Override
        CompoundTag writeDetail(CompoundTag tag) {
            TargetIterator.XZPair xzPair = (TargetIterator.XZPair)this.iterator.peek();
            tag.m_128405_("currentX", xzPair.x());
            tag.m_128405_("currentZ", xzPair.z());
            return tag;
        }

        @Override
        String key() {
            return "FillerWork";
        }

        @Override
        public void tick(Level level, BlockPos pos, BlockState state, TileAdvQuarry quarry) {
            TargetIterator.XZPair target = (TargetIterator.XZPair)this.iterator.peek();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(target.x(), 0, target.z());
            for (int y = quarry.digMinY + 1; y < pos.m_123342_(); ++y) {
                mutablePos.m_142448_(y);
                BlockState targetState = quarry.getTargetWorld().m_8055_((BlockPos)mutablePos);
                if (!targetState.m_247087_()) continue;
                long energy = PowerManager.getFillerEnergy(quarry) * 10L;
                if (quarry.useEnergy(energy, PowerTile.Reason.FILLER, false)) {
                    BlockState toReplace = FillerAction.getToReplace((ResourceKey<Level>)quarry.getTargetWorld().m_46472_(), (BlockPos)mutablePos);
                    quarry.getTargetWorld().m_46597_((BlockPos)mutablePos, toReplace);
                    continue;
                }
                return;
            }
            this.iterator.next();
            if (!this.iterator.hasNext()) {
                quarry.setAction(Finished.FINISHED);
            }
        }

        @Override
        double getProgress(TileAdvQuarry quarry) {
            if (quarry.getArea() == null) {
                return 1.0;
            }
            TargetIterator iterator = this.createTargetIterator(quarry.getArea(), quarry.workConfig.chunkByChunk());
            return AdvQuarryAction.getProgressOfIterator(iterator, (TargetIterator.XZPair)this.iterator.peek());
        }
    }

    public static final class Finished
    extends AdvQuarryAction {
        public static final Finished FINISHED = new Finished();

        private Finished() {
        }

        @Override
        CompoundTag writeDetail(CompoundTag tag) {
            return tag;
        }

        @Override
        String key() {
            return "Finished";
        }

        @Override
        public void tick(Level level, BlockPos pos, BlockState state, TileAdvQuarry quarry) {
        }

        @Override
        double getProgress(TileAdvQuarry quarry) {
            return 1.0;
        }
    }

    public static final class CheckFluid
    extends AdvQuarryAction {
        private final TargetIterator iterator;

        public CheckFluid(TileAdvQuarry quarry) {
            assert (quarry.getArea() != null);
            this.iterator = this.createTargetIterator(quarry.getArea(), quarry.workConfig.chunkByChunk());
        }

        CheckFluid(TileAdvQuarry quarry, int x, int z) {
            assert (quarry.getArea() != null);
            this.iterator = this.createTargetIterator(quarry.getArea(), quarry.workConfig.chunkByChunk());
            this.iterator.setCurrent(new TargetIterator.XZPair(x, z));
        }

        @Override
        CompoundTag writeDetail(CompoundTag tag) {
            TargetIterator.XZPair xzPair = (TargetIterator.XZPair)this.iterator.peek();
            tag.m_128405_("currentX", xzPair.x());
            tag.m_128405_("currentZ", xzPair.z());
            return tag;
        }

        @Override
        String key() {
            return "CheckFluid";
        }

        @Override
        public void tick(Level level, BlockPos pos, BlockState state, TileAdvQuarry quarry) {
            int count = 0;
            ServerLevel targetWorld = quarry.getTargetWorld();
            while (count < 32 && this.iterator.hasNext()) {
                boolean flagRemoved = false;
                TargetIterator.XZPair target = (TargetIterator.XZPair)this.iterator.peek();
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(target.x(), 0, target.z());
                if (this.isChunkUnavailableAtPos((Level)targetWorld, pos)) {
                    quarry.setAction(Finished.FINISHED);
                    return;
                }
                for (int y = quarry.digMinY + 1; y < pos.m_123342_() - 1; ++y) {
                    boolean blockIsReplaced;
                    mutableBlockPos.m_142448_(y);
                    BlockState blockState = targetWorld.m_8055_((BlockPos)mutableBlockPos);
                    boolean blockCondition = blockState.m_60713_((Block)Holder.BLOCK_DUMMY) || blockState.m_60713_(Blocks.f_50069_) || blockState.m_60713_(Blocks.f_50652_);
                    boolean bl = blockIsReplaced = quarry.getReplacementState() == blockState;
                    if (!blockCondition || blockIsReplaced) continue;
                    targetWorld.m_7731_((BlockPos)mutableBlockPos, Blocks.f_50016_.m_49966_(), 3);
                    flagRemoved = true;
                }
                this.iterator.next();
                if (!flagRemoved) continue;
                ++count;
            }
            if (!this.iterator.hasNext()) {
                if (quarry.hasFillerModule()) {
                    quarry.setAction(new FillerWork(quarry));
                } else {
                    quarry.setAction(Finished.FINISHED);
                }
            }
        }

        @Override
        double getProgress(TileAdvQuarry quarry) {
            if (quarry.getArea() == null) {
                return 1.0;
            }
            TargetIterator iterator = this.createTargetIterator(quarry.getArea(), quarry.workConfig.chunkByChunk());
            return AdvQuarryAction.getProgressOfIterator(iterator, (TargetIterator.XZPair)this.iterator.peek());
        }
    }
}

