/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import com.supermartijn642.simplemagnets.packets.magnet.PacketItemInfo;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleMagnetMessage;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class MagnetItem
extends BaseItem {
    public MagnetItem() {
        super(ItemProperties.create().group((CreativeModeTab)SimpleMagnets.GROUP).maxStackSize(1));
    }

    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        MagnetItem.toggleMagnet(player, stack);
        return BaseItem.ItemUseResult.success((ItemStack)stack);
    }

    public static void toggleMagnet(Player player, ItemStack stack) {
        if (!player.m_9236_().f_46443_ && stack.m_41720_() instanceof MagnetItem) {
            boolean active = stack.m_41784_().m_128441_("active") && stack.m_41784_().m_128471_("active");
            stack.m_41784_().m_128379_("active", !active);
            SimpleMagnets.CHANNEL.sendToPlayer(player, (BasePacket)new PacketToggleMagnetMessage(active));
        }
    }

    public void inventoryUpdate(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (entity.m_5833_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("active") && tag.m_128471_("active")) {
            AABB area;
            int r;
            if (this.canPickupItems(tag)) {
                r = this.getRangeItems(tag);
                area = new AABB(entity.m_20182_().m_82520_((double)(-r), (double)(-r), (double)(-r)), entity.m_20182_().m_82520_((double)r, (double)r, (double)r));
                List items = level.m_142425_((EntityTypeTest)EntityType.f_20461_, area, item -> !(!item.m_6084_() || level.f_46443_ && item.f_19797_ <= 1 || item.f_31988_ != null && item.f_31988_.equals(entity.m_20148_()) && item.m_32063_() || item.m_32055_().m_41619_() || item.getPersistentData().m_128441_("PreventRemoteMovement") || !this.canPickupStack(tag, item.m_32055_())));
                items.forEach(item -> item.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
                if (!level.f_46443_ && entity instanceof Player && CommonUtils.isModLoaded((String)"itemphysic")) {
                    items.forEach(item -> MagnetItem.playerTouch(item, (Player)entity));
                }
            }
            if (!level.f_46443_ && this.canPickupXp(tag) && entity instanceof Player) {
                r = this.getRangeXp(tag);
                area = new AABB(entity.m_20182_().m_82520_((double)(-r), (double)(-r), (double)(-r)), entity.m_20182_().m_82520_((double)r, (double)r, (double)r));
                Player player = (Player)entity;
                List orbs = level.m_45976_(ExperienceOrb.class, area);
                orbs.forEach(orb -> {
                    orb.f_19802_ = 0;
                    player.f_36101_ = 0;
                    orb.m_6123_(player);
                });
            }
        }
    }

    private static void playerTouch(ItemEntity itemEntity, Player player) {
        if (!itemEntity.m_9236_().f_46443_) {
            if (itemEntity.m_32063_()) {
                return;
            }
            ItemStack itemstack = itemEntity.m_32055_();
            Item item = itemstack.m_41720_();
            int i = itemstack.m_41613_();
            int hook = ForgeEventFactory.onItemPickup((ItemEntity)itemEntity, (Player)player);
            if (hook < 0) {
                return;
            }
            ItemStack copy = itemstack.m_41777_();
            if (!(itemEntity.m_32063_() || itemEntity.m_19749_() != null && itemEntity.lifespan - itemEntity.m_32059_() > 200 && !itemEntity.m_19749_().equals((Object)player.m_20148_()) || hook != 1 && i > 0 && !player.m_150109_().m_36054_(itemstack))) {
                copy.m_41764_(copy.m_41613_() - itemstack.m_41613_());
                ForgeEventFactory.firePlayerItemPickupEvent((Player)player, (ItemEntity)itemEntity, (ItemStack)copy);
                player.m_7938_((Entity)itemEntity, i);
                if (itemstack.m_41619_()) {
                    itemEntity.m_146870_();
                    itemstack.m_41764_(i);
                }
                player.m_6278_(Stats.f_12984_.m_12902_((Object)item), i);
                player.m_21053_(itemEntity);
            }
        }
    }

    protected abstract boolean canPickupItems(CompoundTag var1);

    protected abstract boolean canPickupStack(CompoundTag var1, ItemStack var2);

    protected abstract boolean canPickupXp(CompoundTag var1);

    protected abstract int getRangeItems(CompoundTag var1);

    protected abstract int getRangeXp(CompoundTag var1);

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41784_().m_128441_("active") && stack.m_41784_().m_128471_("active");
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        info.accept(this.getTooltip());
    }

    protected abstract Component getTooltip();

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking e) {
        if (!e.getEntity().m_9236_().f_46443_ && e.getTarget() instanceof ItemEntity && ((ItemEntity)e.getTarget()).f_31988_ != null) {
            SimpleMagnets.CHANNEL.sendToPlayer(e.getEntity(), (BasePacket)new PacketItemInfo((ItemEntity)e.getTarget()));
        }
    }
}

