/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.handlers.mekanism;

import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.modintegration.handlers.mekanism.WrapperPigmentHandler;

public class TypePigment {
    public static void init() {
        if (((Boolean)Configuration.INTEGRATION.storeMekanismPigment.get()).booleanValue() && IPigmentHandler.class != null) {
            HandlerRegistry.register(Capabilities.PIGMENT_HANDLER, PigmentTankHandler.Provider.INSTANCE);
        }
    }

    public static class PigmentTankHandler
    implements ITankHandler<IPigmentHandler> {
        private final ChemicalTankBuilder.BasicPigmentTank pigmentTank;
        private final IPigmentHandler pigmentTankInsertOnly;
        private final IPigmentHandler pigmentTankExtractOnly;
        private long tankCapacity;

        public PigmentTankHandler(final IEnderTankInfo tank) {
            this.tankCapacity = (long)tank.getCapacity() * 1000L;
            this.pigmentTank = new ChemicalTankBuilder.BasicPigmentTank(this.tankCapacity, (stack, type) -> true, (stack, type) -> true, stack -> true, ChemicalAttributeValidator.ALWAYS_ALLOW, null){

                public long getCapacity() {
                    return tankCapacity;
                }

                public void onContentsChanged() {
                    tank.notifyContentsChange();
                }
            };
            this.pigmentTankInsertOnly = new WrapperPigmentHandler((IPigmentHandler)this.pigmentTank, true, false);
            this.pigmentTankExtractOnly = new WrapperPigmentHandler((IPigmentHandler)this.pigmentTank, false, true);
        }

        @Override
        public IPigmentHandler getTank(StorageAccessMode access) {
            return switch (access) {
                case StorageAccessMode.INSERT_ONLY -> this.pigmentTankInsertOnly;
                case StorageAccessMode.EXTRACT_ONLY -> this.pigmentTankExtractOnly;
                default -> this.pigmentTank;
            };
        }

        @Override
        public void setCapacity(int capacity) {
            int newCapacity = capacity * 1000;
            if (this.tankCapacity != (long)newCapacity) {
                this.tankCapacity = newCapacity;
                this.pigmentTank.onContentsChanged();
            }
        }

        @Override
        public void load(CompoundTag nbt) {
            this.pigmentTank.deserializeNBT(nbt);
        }

        @Override
        public CompoundTag save() {
            return !this.pigmentTank.isEmpty() ? this.pigmentTank.serializeNBT() : null;
        }

        @Override
        public MutableComponent getContentsInfo() {
            PigmentStack stack = (PigmentStack)this.pigmentTank.getStack();
            if (!stack.isEmpty()) {
                return Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"info.endertanks.tank.type.mekanism.pigment")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)stack.getTranslationKey())).m_130946_(" [" + (float)stack.getAmount() / 1000.0f + "K/" + this.pigmentTank.getCapacity() / 1000L + "K mB]");
            }
            return null;
        }

        @Override
        public void preformPumpAction(Level world, BlockPos pos, Direction facing, BlockPos pullFromPos, BlockPos pushToPos, int pumpCapacity, RandomSource random) {
            IPigmentHandler toHandler;
            PigmentStack pigmentStack;
            long used;
            IPigmentHandler fromHandler;
            if (this.pigmentTank.getStored() < this.pigmentTank.getCapacity() && (fromHandler = this.getHandler(world.m_7702_(pullFromPos), facing)) != null && (used = (pigmentStack = (PigmentStack)fromHandler.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((PigmentStack)this.pigmentTank.insertChemical((ChemicalStack)pigmentStack, Action.SIMULATE)).getAmount()) > 0L) {
                this.pigmentTank.insertChemical((ChemicalStack)((PigmentStack)fromHandler.extractChemical(used, Action.EXECUTE)), Action.EXECUTE);
            }
            if (!this.pigmentTank.isEmpty() && (toHandler = this.getHandler(world.m_7702_(pushToPos), facing.m_122424_())) != null && (used = (pigmentStack = (PigmentStack)this.pigmentTank.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((PigmentStack)toHandler.insertChemical((ChemicalStack)pigmentStack, Action.SIMULATE)).getAmount()) > 0L) {
                toHandler.insertChemical((ChemicalStack)((PigmentStack)this.pigmentTank.extractChemical(used, Action.EXECUTE)), Action.EXECUTE);
            }
        }

        @Override
        public int getComparatorOutput() {
            long amount = ((PigmentStack)this.pigmentTank.getStack()).getAmount();
            float fill = (float)amount / (float)this.pigmentTank.getCapacity();
            return Mth.m_14143_((float)(fill * 14.0f)) + (amount > 0L ? 1 : 0);
        }

        @Override
        public Component getDisplayName() {
            return Component.m_237115_((String)"info.endertanks.tank.type.mekanism.pigment");
        }

        public IPigmentHandler getHandler(BlockEntity tile, Direction facing) {
            return tile == null ? null : (IPigmentHandler)tile.getCapability(Capabilities.PIGMENT_HANDLER, facing).orElse(null);
        }

        public static class Provider
        implements HandlerRegistry.ITankHandlerProvider<IPigmentHandler> {
            public static Provider INSTANCE = new Provider();

            @Override
            public ITankHandler<IPigmentHandler> create(IEnderTankInfo tank) {
                return new PigmentTankHandler(tank);
            }
        }
    }
}

